#include "mbed.h"
#include "PubSubClient.h"   //MQTT- Bibliothek
#include "LCD.h"            //LCD-Display-Bibliothek

/*
"mqtt-broker-hostname": {
            "help": "MQTT Broker resolvable hostname.",
            "value": "\"test.mosquitto.org\""
        },
*/
PortOut diag(PortC,0xFF);   //Testausgabe für Binärzähler
AnalogIn poti(PA_0);        //Testsensor Analogeingang Drehknopf    
lcd mylcd;                  //LCD-Display

PubSubClient client;        //Deklaration des MQTT-Clients

Thread thread;
/*
//Beschreibung von Message und MessageData
struct Message
{
    enum QoS qos;
    bool retained;
    bool dup;
    unsigned short id;
    void *payload;
    size_t payloadlen;
};

//MessageData beinhaltet Message und Topicname
struct MessageData
{
    MessageData(MQTTString &aTopicName, struct Message &aMessage)  : message(aMessage), topicName(aTopicName)
    { }

    struct Message &message;
    MQTTString &topicName;
};
*/

//Subscribe-Callbacks
void subscribeCallback(MessageData& mymessage)
{
    mylcd.cursorpos(0);
    //Der Inhalt einer Botschaft (payload) kann als String mit gibPayload 
    //abgerufen werden
    mylcd.printf("%s   ",client.gibPayload(mymessage).c_str());
}

void subscribeCallback2(MessageData& mymessage)
{
    mylcd.cursorpos(0x40);
    mylcd.printf("%s   ",client.gibPayload(mymessage).c_str());
}

void mqtt(void)
{
    char buffer[64];
    int d;
    while(true)
    {
        client.loop();  //Auf neue Botschaften prüfen
        d=diag;         //Zählerstand speichern
        //Poti veröffentlichen
        sprintf(buffer, "poti=%d", (int)(poti*4095)); //Potiwert in buffer speichern
        client.publish("MBED/oehringen/ersteTests", buffer,QOS1); //unter Topic veröffentlichen
        //diag veröffentlichen
        sprintf(buffer, "diag=%d", d); //diag in buffer speichern
        client.publish("MBED/oehringen/zweiteTests", buffer,QOS2); //unter Topic veröffentlichen
    }
}


//test.mosquitto.org 5.196.95.208
int main()
{
    diag=1;

    mylcd.clear();
    client.connect((char*)"joerg"); //Verbinde Client mit ID 
    //Client für topic einschreiben
    client.subscribe("MBED/oehringen/ersteTests", QOS0, subscribeCallback); 
    client.subscribe("MBED/oehringen/zweiteTests", QOS0, subscribeCallback2); 
    thread.start(mqtt);
    while(true)
    {
        diag=diag+1;    //Zähler auf PortC
        ThisThread::sleep_for(500);

    }
}




