#include "mbed.h"
#include "PubSubClient.h"
#include "LCD.h"
/*
        "wifi-ssid": {
            "help": "WiFi SSID",
            "value": "\"x-Netz\""
        },
        "wifi-password": {
            "help": "WiFi Password",
            "value": "\"aCT3xuSbm9rt\""
        },
*/
/*
"mqtt-broker-hostname": {
            "help": "MQTT Broker resolvable hostname.",
            "value": "\"test.mosquitto.org\""
        },
*/
PortOut diag(PortC,0xFF);
AnalogIn poti(PA_0);
lcd mylcd;

PubSubClient client;

/*
struct Message
{
    enum QoS qos;
    bool retained;
    bool dup;
    unsigned short id;
    void *payload;
    size_t payloadlen;
};


struct MessageData
{
    MessageData(MQTTString &aTopicName, struct Message &aMessage)  : message(aMessage), topicName(aTopicName)
    { }

    struct Message &message;
    MQTTString &topicName;
};
*/

void subscribeCallback(MessageData& mymessage)
{
    mylcd.cursorpos(0);
    mylcd.printf("%s   ",client.gibPayload(mymessage).c_str());
}

void subscribeCallback2(MessageData& mymessage)
{

    mylcd.cursorpos(0x40);
    mylcd.printf("%s   ",client.gibPayload(mymessage).c_str());
}


//test.mosquitto.org 5.196.95.208
int main()
{
    diag=1;
    int d;
    char buffer[64];
    mylcd.clear();
    client.connect((char*)"joerg");  
    client.subscribe("MBED/joerg/ersteTests", QOS0, subscribeCallback); 
    client.subscribe("MBED/joerg/zweiteTests", QOS0, subscribeCallback2); 
    while(true)
    {
        client.loop();
        diag=diag+1;
        d=diag;
        sprintf(buffer, "poti=%d", (int)(poti*4095));
        client.publish("MBED/joerg/ersteTests", buffer);
        //HAL_Delay(200);
        sprintf(buffer, "diag=%d", d);
        client.publish("MBED/joerg/zweiteTests", buffer);
        //HAL_Delay(200);
    }
}




