#include "mbed.h"
#include "PubSubClient.h"   //MQTT- Bibliothek
#include "LCD.h"            //LCD-Display-Bibliothek
/*
        "wifi-ssid": {
            "help": "WiFi SSID",
            "value": "\"x-Netz\""
        },
        "wifi-password": {
            "help": "WiFi Password",
            "value": "\"aCT3xuSbm9rt\""
        },
*/
/*
"mqtt-broker-hostname": {
            "help": "MQTT Broker resolvable hostname.",
            "value": "\"test.mosquitto.org\""
        },
*/
PortOut diag(PortC,0xFF);   //Testausgabe für Binärzähler
AnalogIn poti(PA_0);        //Testsensor Analogeingang Drehknopf    
lcd mylcd;                  //LCD-Display

PubSubClient client;        //Deklaration des MQTT-Clients

/*
//Beschreibung von Message und MessageData
struct Message
{
    enum QoS qos;
    bool retained;
    bool dup;
    unsigned short id;
    void *payload;
    size_t payloadlen;
};

//MessageData beinhaltet Message und Topicname
struct MessageData
{
    MessageData(MQTTString &aTopicName, struct Message &aMessage)  : message(aMessage), topicName(aTopicName)
    { }

    struct Message &message;
    MQTTString &topicName;
};
*/

//Subscribe-Callbacks
void subscribeCallback(MessageData& mymessage)
{
    mylcd.cursorpos(0);
    //Der Inhalt einer Botschaft (payload) kann als String mit gibPayload 
    //abgerufen werden
    mylcd.printf("%s   ",client.gibPayload(mymessage).c_str());
}

void subscribeCallback2(MessageData& mymessage)
{
    mylcd.cursorpos(0x40);
    mylcd.printf("%s   ",client.gibPayload(mymessage).c_str());
}


//test.mosquitto.org 5.196.95.208
int main()
{
    diag=1;
    int d;
    char buffer[64];
    mylcd.clear();
    client.connect((char*)"joerg"); //Verbinde Client mit ID 
    //Client für topic einschreiben
    client.subscribe("MBED/joerg/ersteTests", QOS0, subscribeCallback); 
    client.subscribe("MBED/joerg/zweiteTests", QOS0, subscribeCallback2); 
    while(true)
    {
        client.loop();  //Auf neue Botschaften prüfen
        diag=diag+1;    //Zähler auf PortC
        d=diag;         //Zählerstand speichern
        //Poti veröffentlichen
        sprintf(buffer, "poti=%d", (int)(poti*4095)); //Potiwert in buffer speichern
        client.publish("MBED/joerg/ersteTests", buffer); //unter Topic veröffentlichen
        //HAL_Delay(200);
        //diag veröffentlichen
        sprintf(buffer, "diag=%d", d); //diag in buffer speichern
        client.publish("MBED/joerg/zweiteTests", buffer); //unter Topic veröffentlichen
        //HAL_Delay(200);
    }
}




