#include "mbed.h"
#include "PubSubClient.h"   //MQTT Bibliothek einbinden
#include "LCD.h"

PortOut diag(PortC,0xFF);   //Testanzeige zu Diagnosezwecken
AnalogIn poti(PA_0);        //Testsensor Drehknopf
lcd mylcd;

PubSubClient client;

void subscribeCallback(MessageData& mymessage)
{
    mylcd.cursorpos(0);
    mylcd.printf("%s   ",client.gibPayload(mymessage).c_str());
}

void subscribeCallback2(MessageData& mymessage)
{

    mylcd.cursorpos(0x40);
    mylcd.printf("%s   ",client.gibPayload(mymessage).c_str());
}


int main()
{
    diag=1;
    int d;
    char buffer[64];
    mylcd.clear();
    client.connect((char*)"joerg");  
    client.subscribe("MBED/joerg/ersteTests", QOS0, subscribeCallback); 
    client.subscribe("MBED/joerg/zweiteTests", QOS0, subscribeCallback2); 
    while(true)
    {
        client.loop();
        diag=diag+1;
        d=diag;
        sprintf(buffer, "poti=%d", (int)(poti*4095));
        client.publish("MBED/joerg/ersteTests", buffer);
        //HAL_Delay(200);
        sprintf(buffer, "diag=%d", d);
        client.publish("MBED/joerg/zweiteTests", buffer);
        //HAL_Delay(200);
    }
}




