#include "mbed.h"
#include "PubSubClient.h"   //MQTT- Bibliothek
#include "LCD.h"            //LCD-Display-Bibliothek

#define A 0b00001
#define B 0b00010
#define C 0b00100
#define D 0b01000
#define Voll 0b00000

PortOut zustand(PortC,0x1F);


PubSubClient client;        //Deklaration des MQTT-Clients
InterruptIn Lichtschranke(PA_1);
char buffer[64];
int anzahl;
bool einfahrt=false;

void lichtschranke()
{
    if (einfahrt==false)
    {
        switch (zustand)
        {
            case A: anzahl++; if (anzahl==22) zustand=B; break; 
            case B: anzahl++; if (anzahl==44) zustand=C; break;
            case C: anzahl++; if (anzahl==66) zustand=D; break;
            case D: anzahl++; if (anzahl==88) zustand=Voll; break;           
        }
        einfahrt=true;
    }
}

//Subscribe-Callbacks
void callback(MessageData& mymessage)
{
        zustand=A;
        anzahl=0;
        sprintf(buffer, "Fahrzeuge=%d", anzahl); //Potiwert in buffer speichern
        client.publish("MBED/oehringen/faehrschiff", buffer); //unter Topic veröffentlichen 
}

void mqtt()
{
    client.loop();  //Auf neue Botschaften prüfen
    if (einfahrt)
    {
        sprintf(buffer, "Fahrzeuge=%d", anzahl); //Potiwert in buffer speichern
        client.publish("MBED/oehringen/faehrschiff", buffer); //unter Topic veröffentlichen  
        HAL_Delay(200); 
        einfahrt=false;
    }
}

void init()
{
    client.connect((char*)"joerg"); 
    client.subscribe("MBED/oehringen/faehrschiffLeer", QOS0, callback); 
    Lichtschranke.fall(&lichtschranke);
    Lichtschranke.mode(PullDown);
    zustand=A;
    anzahl=0;    
}

int main()
{
    init();
    while(true)
    {
        mqtt();
    }
}




