/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "LCD.h"

lcd mylcd;
int zeit= 100; //Zeit in ms

PortOut zustand(PortC,0b111111);
DigitalOut warnlampe(PC_7);

InterruptIn TrocknenEin(PA_10);
InterruptIn TrocknenAus(PA_6);
DigitalIn Lichtschranke(PB_0);


//Zustandsdefinitionen
#define Aus 0b0000
#define Anlaufen 0b1110
#define Betrieb 0b1111
#define Abschalten 0b0111
#define HaltAnlaufen 0b010000
#define HaltBetrieb  0b100000
#define HaltAbschalten 0b110000




void melden(const char* txt)
{
    mylcd.clear();
    mylcd.cursorpos(0);
    mylcd.printf("%s",txt);
}

void trocknenEin()
{
    if (zustand==Aus)
    {
        zustand=Anlaufen;
        melden("Anlauf");
    }
}

void trocknenAus()
{
    if (zustand==Betrieb)
    {
        warnlampe=0;
        zustand=Abschalten;
        melden("Abschalten");
    }
}

InterruptIn HALT(PB_4); 
void halt(){
    switch (zustand)
    {
        case Anlaufen: zustand=HaltAnlaufen; melden("Halt"); break;
        case Betrieb: zustand=HaltBetrieb; melden("Halt"); break;
        case Abschalten: zustand=HaltAbschalten; melden("Halt"); break;
    }
    

}
int z=0;
void ueberwachen()
{
    if (z>5) warnlampe=0;
    else warnlampe=1;
    z=0;
}
void luefter()
{
    z++;
}
InterruptIn Luefter(PA_1);
void init()
{
    Luefter.rise(&luefter);
    HALT.mode(PullDown);
    HALT.rise(&halt);
    TrocknenEin.mode(PullDown);
    TrocknenAus.mode(PullDown);
    Lichtschranke.mode(PullDown);
    
    TrocknenEin.rise(&trocknenEin);
    TrocknenAus.rise(&trocknenAus);
    
    zustand=Aus;
}



int main()
{
    init();
    melden("bereit");

    while (true) {
        switch(zustand)
        {
            case Anlaufen: 
                if (Lichtschranke==1)
                {
                    zustand=Betrieb;
                    melden("Betrieb");
                }
                break;
            case Abschalten: 
                if (Lichtschranke==0)
                {
                    zustand=Aus;
                    melden("bereit");
                }
                break;
            case HaltAnlaufen:
                if (HALT==0){
                    zustand=Anlaufen;
                    melden("Anlaufen");
                    }
                break;
            case HaltBetrieb:
                if (HALT==0){
                    zustand=Betrieb;
                    melden("Betrieb");
                    }
                break;
            case HaltAbschalten:
                if (HALT==0){
                    zustand=Abschalten;
                    melden("Abschalten");
                    }
                break;
            case Betrieb: ueberwachen();
                break;
        }

        HAL_Delay(zeit);
    }
}
