/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "LCD.h"

lcd mylcd;
int zeit= 100; //Zeit in ms

PortOut zustand(PortC,0b1111);
DigitalOut warnlampe(PC_7);

InterruptIn TrocknenEin(PA_10);
InterruptIn TrocknenAus(PA_6);
DigitalIn Lichtschranke(PB_0);

//Zustandsdefinitionen
#define Aus 0b0000
#define Anlaufen 0b1110
#define Betrieb 0b1111
#define Abschalten 0b0111

void melden(const char* txt)
{
    mylcd.clear();
    mylcd.cursorpos(0);
    mylcd.printf("%s",txt);
}

void trocknenEin()
{
    if (zustand==Aus)
    {
        zustand=Anlaufen;
        melden("Anlauf");
    }
}

void trocknenAus()
{
    if (zustand==Betrieb)
    {
        zustand=Abschalten;
        melden("Abschalten");
    }
}

void init()
{
    TrocknenEin.mode(PullDown);
    TrocknenAus.mode(PullDown);
    Lichtschranke.mode(PullDown);
    
    TrocknenEin.rise(&trocknenEin);
    TrocknenAus.rise(&trocknenAus);
    
    zustand=Aus;
}

int main()
{
    init();
    melden("bereit");

    while (true) {
        switch(zustand)
        {
            case Anlaufen: 
                if (Lichtschranke==1)
                {
                    zustand=Betrieb;
                    melden("Betrieb");
                }
                break;
            case Abschalten: 
                if (Lichtschranke==0)
                {
                    zustand=Aus;
                    melden("bereit");
                }
                break;
        }

        HAL_Delay(zeit);
    }
}
