/* ATCmdParser usage example
 * Copyright (c) 2016 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "ESP8266Webserver.h"
#include "LCD.h"

lcd myLCD;
ESP8266Webserver myWebserver;
AnalogIn poti(PA_0);
DigitalOut myled(PC_0);
string getRootPage()
{
      string webpage;
      webpage="<!DOCTYPE html>";
      //HTML
      webpage+="<html>";
      webpage+="<head>";
      webpage+="<title>STM32 HTTP</title>";
      webpage+="</head>";
      webpage+="<body>";
      webpage+="<h1>WIFI mit STM32 ESP01</h1>\n";
      webpage+="<p>Poti:"+to_string(poti)+"</p>\n"; 
      webpage+="<a href=\"ledAn\"><button>ON</button></a>\n";      
      webpage+="<a href=\"ledAus\"><button>OFF</button></a>\n";
      webpage+="</body>";
      webpage+="</html>";
      return webpage;
}


void testfunc()
{
    myWebserver.send(200,"text/html",getRootPage());
}

void testfunc2()
{
    myled=0;
    myWebserver.send(200,"text/html",getRootPage());
}

void testfunc3()
{
    myled=1;
    myWebserver.send(200,"text/html",getRootPage());
}

int main() {  
    myWebserver.on("ledAus",&testfunc2);
    myWebserver.on("ledAn",&testfunc3);
    myWebserver.on("/",&testfunc);
    myWebserver.begin();    
    myLCD.clear();
    myLCD.cursorpos(0);
    myLCD.printf("%s",myWebserver.gibIP());
    while(1)  {
         myWebserver.handleClient();
    }
}
