/* ATCmdParser usage example
 * Copyright (c) 2016 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "ESP8266Webserver.h"
#include "LCD.h"

#define VOR 0b1010
#define RUECK 0b0101
#define LINKS 0b1001
#define RECHTS 0b0110
#define STOP 0b0000

lcd myLCD;
ESP8266Webserver myWebserver;
AnalogIn poti(PA_0);
PortOut roboter(PortC,0xFF);
string getRootPage()
{
      string webpage;
      webpage="<!DOCTYPE html>";
      //HTML
      webpage+="<html>";
      webpage+="<head>";
      webpage+="<title>STM32 HTTP</title>";
      webpage+="</head>";
      webpage+="<body>";
      webpage+="<h1>WIFI mit STM32 ESP01</h1>\n";
      webpage+="<table>";
      webpage+="<tr> <td></td> <td><a href=\"vor\"><button>VOR</button></a></td> <td></td> </tr>"; 
      webpage+="<tr> <td><a href=\"links\"><button>LINKS</button></a></td> <td><a href=\"stop\"><button>STOP</button></a></td> <td><a href=\"rechts\"><button>RECHTS</button></a></td></tr>"; 
      webpage+="<tr> <td></td> <td><a href=\"rueck\"><button>RUECK</button></a></td> <td></td> </tr> ";
      webpage+="</table>";
      webpage+="</body>";
      webpage+="</html>";
      return webpage;
}


void testfunc()
{
    myWebserver.send(200,"text/html",getRootPage());
}

void vor()
{
    roboter=VOR;
    myWebserver.send(200,"text/html",getRootPage());
}

void rueck()
{
    roboter=RUECK;
    myWebserver.send(200,"text/html",getRootPage());
}

void links()
{
    roboter=LINKS;
    myWebserver.send(200,"text/html",getRootPage());
}

void rechts()
{
    roboter=RECHTS;
    myWebserver.send(200,"text/html",getRootPage());
}

void stop()
{
    roboter=STOP;
    myWebserver.send(200,"text/html",getRootPage());
}

int main() {  
    myWebserver.on("vor",&vor);
    myWebserver.on("rueck",&rueck);
    myWebserver.on("links",&links);
    myWebserver.on("rechts",&rechts);
    myWebserver.on("stop",&stop);
    
    myWebserver.on("/",&testfunc);
    myWebserver.begin();    
    myLCD.clear();
    myLCD.cursorpos(0);
    myLCD.printf("%s",myWebserver.gibIP());
    while(1)  {
         myWebserver.handleClient();
    }
}
