/* ATCmdParser usage example
 * Copyright (c) 2016 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "ESP8266Webserver.h"
#include "LCD.h"


#define Runterfahren 0b10
#define Hochfahren 0b01
#define Steht 0b00

PortOut zustand(PortC,0b11);

lcd myLCD;
ESP8266Webserver myWebserver;
AnalogIn windstaerke(PA_0);
InterruptIn TO(PA_1);
InterruptIn TU(PA_6);

string getRootPage()
{
      string webpage;
      webpage="<!DOCTYPE html>";
      //HTML
      webpage+="<html>";
      webpage+="<head>";
      webpage+="<title>STM32 HTTP</title>";
      webpage+="</head>";
      webpage+="<body>";
      webpage+="<h1>WIFI mit STM32 ESP01</h1>\n";
      webpage+="<table>";
      webpage+="<tr><td><a href=\"Hoch\"><button>Hoch</button></a></td><td><a href=\"Runter\"><button>Runter</button></a></td></tr>";
      webpage+="<tr><td>";
      webpage+="Windst&auml;rke:"+to_string(windstaerke); 
      webpage+="</td> <td>";
      webpage+="<a href=\"anzeigen\"><button>Anzeigen</button></a>\n";      
      webpage+="</td></tr></table>";
      webpage+="</body>";
      webpage+="</html>";
      return webpage;
}

void endschalterOben()
{
    switch (zustand)
    {
        case Hochfahren: zustand=Steht;
            break;
    }
}

void endschalterUnten()
{
    switch (zustand)
    {
        case Runterfahren: zustand=Steht;
            break;
    }
}

void anzeigen()
{
    myWebserver.send(200,"text/html",getRootPage());
}

void hoch()
{
    switch (zustand)
    {
        case Steht: 
            if (TO==0) 
            {
                zustand=Hochfahren;
            }
            break;
    }
    myWebserver.send(200,"text/html",getRootPage());
}

void runter()
{
    switch (zustand)
    {
        case Steht: 
            if (TU==0 && windstaerke<=0.87) 
            {
                zustand=Runterfahren;
            }
            break;
    }
    myWebserver.send(200,"text/html",getRootPage());
}

void init()
{
    zustand=Steht;
    TO.mode(PullDown);
    TO.rise(&endschalterOben);
    TO.enable_irq();
    TU.mode(PullDown);
    TU.rise(&endschalterUnten);
    TU.enable_irq();
    __enable_irq();
    
    myWebserver.on("/Hoch",&hoch);
    myWebserver.on("/Runter",&runter);
    myWebserver.on("/Anzeigen",&anzeigen);
    myWebserver.on("/",&anzeigen);
    myWebserver.begin();    
    myLCD.clear();
    myLCD.cursorpos(0);
    myLCD.printf("%s",myWebserver.gibIP());
}




int main() {  
    init();

    while(1)  {
         myWebserver.handleClient();
         switch (zustand)
         {
             case Steht: 
                if (windstaerke>0.87 && TO==0)
                {
                    zustand=Hochfahren;
                }
                break;
         }
    }
}
