#include "VH.h"

char VH::gibZeichen(void)
{
    char c;
    while (serial_port->readable()==false); 
    serial_port->read(&c, 1); 
    return c;
}

void VH::setZeichen(char c)
{
    while (serial_port->writable()==false);
    serial_port->write(&c, 1);
}
void VH::eingabe(void)
    { int i=0, pudr;
        while(1)
        {   
            i=0;
            if (serial_port->readable()) { // Chars received?
                serial_port->read(buffer+i, 1); 
                switch (buffer[0])
                {
                    case 14: 
                        i++;
                        buffer[i]=gibZeichen();
                        i++;
                        buffer[i]=gibZeichen();
                        break;
                    //9, 1, 2, 3 Input in PUDR
                    case 9: //Setze Port P0 => PortA Low
                        i++;
                        buffer[i]=gibZeichen();  
                        pudr=0;
                        for (int j=0;j<8;j++)
                        {
                            pudr=pudr<<2;
                            if ((buffer[i]&(1<<(7-j)))!=0) pudr|=0b01; else pudr|=0b10;   
                        }
                        pudr&=~0b11110011;
                        GPIOA->PUPDR=(GPIOA->PUPDR&0xFFFF00F3)|pudr;                     
                        break;
                    case 1: //Setze Port P1  => PortC Low
                        i++; 
                        buffer[i]=gibZeichen();  
                        pudr=0;
                        for (int j=0;j<8;j++)
                        {
                            pudr=pudr<<2;
                            if ((buffer[i]&(1<<(7-j)))!=0) pudr|=0b01; else pudr|=0b10;   
                        }
                        GPIOC->PUPDR=(GPIOC->PUPDR&0xFFFF0000)|pudr;                                         
                        break;
                    case 2: //Setze Port P2  => PortB Low
                        i++; 
                        buffer[i]=gibZeichen();
                        pudr=0;
                        for (int j=0;j<8;j++)
                        {
                            pudr=pudr<<2;
                            if ((buffer[i]&(1<<(7-j)))!=0) pudr|=0b01; else pudr|=0b10;   
                        }
                        GPIOB->PUPDR=(GPIOB->PUPDR&0xFFFF0000)|pudr;               
                        break;
                    case 3: //Setze Port P3 => PortA High
                        i++;
                        buffer[i]=gibZeichen();
                        pudr=0;
                        for (int j=0;j<8;j++)
                        {
                            pudr=pudr<<2;
                            if ((buffer[i]&(1<<(7-j)))!=0) pudr|=0b01; else pudr|=0b10;   
                        }
                        pudr&=~0b0000111100000000;
                        GPIOA->PUPDR=(GPIOA->PUPDR&0x0F00FFFF)|pudr<<16;                         
                        break;
                    case 8: //lese P0
                        break;
                    case 5: //lese P1 (PortC)
                        break;
                    case 6: //lese P2
                        break;
                    case 7: //lese P3
                        break;
                }
                
                ausgabe(buffer[0]);
            }
        }
    }
    void VH::ausgabe(char nr)
    {

        a=buffer[0];
        b=buffer[1];
        c=buffer[2];
        switch(nr)
        {
            case 14:

                outbuffer[0]=14;
                outbuffer[1]=1;
                outbuffer[3]=0;
                for (int i=0; i<3;i++) setZeichen(outbuffer[i]);
                break;
            case 9: //Setze Port P0 => PortA Low
            case 1: //Setze Port P1  => PortC Low
            case 2: //Setze Port P2  => PortB Low
            case 3: //Setze Port P3 => PortA High
                for (int i=0; i<2;i++) setZeichen(buffer[i]);
                break;
            case 8: //lese P0 = PortA Low
                outbuffer[0]=buffer[0];
                outbuffer[1]=GPIOA->IDR&0xFF;
                for (int i=0; i<2;i++) setZeichen(outbuffer[i]);
                break;
            case 5: //lese P1 = PortC Low
                outbuffer[0]=buffer[0];
                outbuffer[1]=GPIOC->ODR&0xFF;
                for (int i=0; i<2;i++) setZeichen(outbuffer[i]);
                break;
            case 6: //lese P2 = PortB Low
                outbuffer[0]=buffer[0];
                outbuffer[1]=GPIOB->IDR&0xFF;
                for (int i=0; i<2;i++) setZeichen(outbuffer[i]);
                break;
            case 7: //lese P3 = PortA High
                outbuffer[0]=buffer[0];
                outbuffer[1]=(GPIOA->IDR>>8)&0xFF;
                for (int i=0; i<2;i++) setZeichen(outbuffer[i]);
                break;
            
        }
    }
    VH::VH(void)
    {
        serial_port=new BufferedSerial(USBTX, USBRX);
        warteAufEingabe=new Thread();
        warteAufEingabe->start(callback(this,&VH::eingabe));
    }