/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "LCD.h"


// Blinking rate in milliseconds
#define BLINKING_RATE     500ms
BufferedSerial hc05(PB_10,PB_11,9600);
AnalogIn ain2(PA_4);

lcd mylcd;

int main()
{
    char daten[15];
    
    float Wert = 0; // variable to store the value read
    float R2_25 =1500;
    float R2_theta;
    float R1=1500;
    float dt;
    float t;
    float alpha=-0.045;

    // Initialise the digital pin LED1 as an output
    DigitalOut led(LED1);
    mylcd.clear();
    mylcd.cursorpos(0);
    while (true) {
        led = !led;
        R2_theta=R1*ain2/(1-ain2);
        dt=(R2_theta/R2_25-1)/alpha; //näherungsweise
        t=25+dt;
        sprintf(daten,"*G%d*",(int)t);
        hc05.write(daten,12);
        sprintf(daten,"*T%d*",(int)t);
        hc05.write(daten,12);
        mylcd.cursorpos(0);
        mylcd.printf("%s",daten);
        ThisThread::sleep_for(BLINKING_RATE);
    }
}
