#include "mbed.h"


DigitalOut myled(PC_0);
DigitalOut myled2(PC_1);
DigitalOut PC2(PC_2);

void EX1IRQhandler(void)
{
    PC2=!PC2;
}

void TIM6_IRQHandler(void)
{
    myled=!myled;
    TIM6->SR=0;
    HAL_NVIC_ClearPendingIRQ(TIM6_IRQn);
}
void TIM7_IRQHandler(void)
{
    myled2=!myled2;
    TIM7->SR=0;
    HAL_NVIC_ClearPendingIRQ(TIM7_IRQn);
}
InterruptIn PA1(PA_1);
void EX1init(void)
{
PA1.rise(&EX1IRQhandler);
PA1.mode(PullDown);
}

void NVIC_Init(void)
{
    /* TIM6_IRQn interrupt configuration */
    NVIC_SetVector(TIM6_IRQn, (uint32_t)&TIM6_IRQHandler);
    HAL_NVIC_EnableIRQ(TIM6_IRQn);
   /* TIM7_IRQn interrupt configuration */
    NVIC_SetVector(TIM7_IRQn, (uint32_t)&TIM7_IRQHandler);
    HAL_NVIC_EnableIRQ(TIM7_IRQn);
}

/* TIM6 init function */
void TIM6_Init(void)
{
    RCC->APB1ENR|=0b10000;  //Clock Enable
    TIM6->PSC=3199;         //Prescaler 100µs
    TIM6->ARR=5000;         //Autoreload 5000*100µs = 0,5s
    TIM6->DIER=1;           //UIE = 1 (Update Interrupt Enable)
    TIM6->SR=0;             //UIF =0 (Update Interrupt Flag)
    TIM6->CR1=1;            //CEN=1 (Counter Enable)
}
void TIM7_Init(void)
{
    RCC->APB1ENR|=0b100000;  //Clock Enable
    TIM7->PSC=3199;         //Prescaler 100µs
    TIM7->ARR=15000;         //Autoreload 15000*100µs = 1,5s
    TIM7->DIER=1;           //UIE = 1 (Update Interrupt Enable)
    TIM7->SR=0;             //UIF =0 (Update Interrupt Flag)
    TIM7->CR1=1;            //CEN=1 (Counter Enable)
}

int main()
{
    TIM6_Init();
    TIM7_Init();
    EX1init();
    NVIC_Init();
    while(1) {
    }

}