#include "mbed.h"


DigitalOut myled(PC_0);
DigitalOut myled2(PC_1);
DigitalOut PC2(PC_2);

void EX1IRQhandler(void)
{
    PC2=!PC2;
}

void TIM2_IRQHandler(void)
{
    myled=!myled;
    TIM2->SR=0;
    HAL_NVIC_ClearPendingIRQ(TIM2_IRQn);
}
void TIM3_IRQHandler(void)
{
    myled2=!myled2;
    TIM3->SR=0;
    HAL_NVIC_ClearPendingIRQ(TIM3_IRQn);
}
InterruptIn PA1(PA_1);
void EX1init(void);


void NVIC_Init(void)
{
    /* TIM2_IRQn interrupt configuration */
    NVIC_SetVector(TIM2_IRQn, (uint32_t)&TIM2_IRQHandler);
    HAL_NVIC_EnableIRQ(TIM2_IRQn);
   /* TIM3_IRQn interrupt configuration */
    NVIC_SetVector(TIM3_IRQn, (uint32_t)&TIM3_IRQHandler);
    HAL_NVIC_EnableIRQ(TIM3_IRQn);
}

/* TIM2 init function */
void TIM2_Init(void)
{
    RCC->APB1ENR|=0b00001;  //Clock Enable
    TIM2->PSC=3199;         //Prescaler 100µs
    TIM2->ARR=5000;         //Autoreload 5000*100µs = 0,5s
    TIM2->DIER=1;           //UIE = 1 (Update Interrupt Enable)
    TIM2->SR=0;             //UIF =0 (Update Interrupt Flag)
    TIM2->CR1=1;            //CEN=1 (Counter Enable)
}
void TIM3_Init(void);



int main()
{
    TIM2_Init();
    TIM3_Init();
    EX1init();
    NVIC_Init();
    while(1) {
    }

}

void EX1init(void)
{
PA1.rise(&EX1IRQhandler);
PA1.mode(PullDown);
}

void TIM3_Init(void)
{
    RCC->APB1ENR|=0b000010;  //Clock Enable
    TIM3->PSC=3199;         //Prescaler 100µs
    TIM3->ARR=15000;         //Autoreload 15000*100µs = 1,5s
    TIM3->DIER=1;           //UIE = 1 (Update Interrupt Enable)
    TIM3->SR=0;             //UIF =0 (Update Interrupt Flag)
    TIM3->CR1=1;            //CEN=1 (Counter Enable)
}