/* ATCmdParser usage example
 * Copyright (c) 2016 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "ESP8266Webserver.h"
#include "LCD.h"

PortOut diag(PortB,0xFF);
lcd myLCD;
ESP8266Webserver myWebserver;
AnalogIn poti(PA_0);
DigitalIn taste(PA_1);



string getRootPage()
{
      string webpage;
      webpage="<!DOCTYPE html>\n";
      //Javascript
      webpage+="<script type=\"text/javascript\">\n";
      webpage+="var x;";
      webpage+="function z(){location.assign(\"http://"+(string)(myWebserver.gibIP())+"\");}";
      webpage+="function sT(){x=setInterval(z,5000);}";
      webpage+="function spT(){clearInterval(x);}";
      webpage+="onload=sT();";
      webpage+="</script>\n";
      //HTML
      webpage+="<html>\n";
      webpage+="<head>\n";
      webpage+="<title>STM32 HTTP</title>\n";
      webpage+="</head>\n";
      webpage+="<body>\n";
      webpage+="<h1>WIFI mit STM32 ESP01</h1>\n";
      webpage+="<p>Aufrufe:"+to_string(myWebserver.Aufrufe)+"</p>\n"; 
      webpage+="<p>Poti:"+to_string(poti)+"</p>\n"; 
      webpage+="<p>Taste PA_1:"+to_string(taste)+"</p>\n"; 
      //Formular
      webpage+="<form>\n";
      webpage+="<label for=\"Suchbegriff\">Suchbegriff</label>\n";
      webpage+="<input id=\"Suchbegriff\" name=\"Suchbegriff\">\n";
      webpage+="<label for=\"checkmich\">check mich:</label>\n";
      webpage+="<input type=\"checkbox\" id=\"checkmich\" name=\"checkmich\">\n";
      webpage+="<button>finden</button>\n";
      webpage+="</form>\n";
      //Buttons
      webpage+="<H2>LED On/Off </H2>\n";
      webpage+="<a href=\"ledAn\"><button>ON</button></a>\n";      
      webpage+="<a href=\"ledaus\"><button>OFF</button></a>\n";
      webpage+="</body>\n";
      webpage+="</html>\n";
  
      return webpage;

}


void testfunc()
{
    diag=diag|0x80;
    
    myWebserver.send(200,"text/html",getRootPage());
}

void testfunc2()
{
    diag=0x40;
    myWebserver.send(200,"text/html",getRootPage());
}
void testfunc3()
{
    diag=0x20;
    myWebserver.send(200,"text/html",getRootPage());
}

void testfunc4()
{
    diag=diag|0x10;
    myLCD.clear();
    myLCD.cursorpos(0);
    myLCD.printf("%s",myWebserver.gibWert("Suchbegriff"));
    myLCD.cursorpos(0x40);
    myLCD.printf("%s",myWebserver.gibWert("checkmich"));
    myWebserver.send(200,"text/html",getRootPage());
}

int main()
{
    taste.mode(PullDown);
    
    myWebserver.on("Suchbegriff",&testfunc4);
    myWebserver.on("ledaus",&testfunc2);
    myWebserver.on("ledAn",&testfunc3);
    myWebserver.on("/",&testfunc);

    myWebserver.begin();
    
    myLCD.clear();
    myLCD.cursorpos(0);
    myLCD.printf("%s",myWebserver.gibIP());
    


    while(1)
    {
         myWebserver.handleClient();
    }
    
}
