/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"
#include "LCD.h"

// Blinking rate in milliseconds
#define BLINKING_RATE_MS                                                    500

lcd mylcd;

int main()
{
    // Initialise the digital pin LED1 as an output
    DigitalOut led(PC_13);
    PortOut leds(PortB,0xF);
    PortIn dips(PortB,0xF0);
    DigitalOut pb2(PB_2);
    DigitalOut pb8(PB_8);
    mylcd.clear();
    mylcd.cursorpos(0);
    mylcd.printf("Hallo welt");
    while (true) {
        led = !led;
        leds=dips>>4;
        mylcd.cursorpos(0x40);
        mylcd.printf("%2X",leds+dips);
        pb8=pb2;    //GPIOB Bit 2 => Bit 8
        thread_sleep_for(BLINKING_RATE_MS);
    }
}
