/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

/* Anschlüsse:
* MOSI: PB15 - D8
* SCLK: DB13 - D7
*/

#include "mbed.h"
#include "platform/mbed_thread.h"


// Blinking rate in milliseconds
#define BLINKING_RATE_MS                                                    5

DigitalOut summer(D3);
DigitalOut SS(D4);
AnalogIn ain(A0);


// Deklarieren Sie die SPI: SPI anzeige(?, ?, ?);

int seg7[10]={0b11000000,0b11111001,0b10100100,
0b10110000,0b10011001,0b10010010,
0b10000010,0b11111000,0b10000000,
0b10010000};

int tausender(int e)
{
    return (seg7[((e%10000)/1000)]<<8)+0b00000001;
}
//ebenso hunderter, zehner und einer
int main()
{
    int eingabe;
    summer=1;  //Summer ausschalten
    // Wählen Sie das richtige Format: anzeige.format(???);
    while (true) {
        eingabe=(int)(ain*4096);
        
        SS=0;
        anzeige.write(tausender(eingabe));
        SS=1;
        thread_sleep_for(BLINKING_RATE_MS);
        //Ebenso hunderter, Zehner, Einer
    }
}
