/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"


// Blinking rate in milliseconds
#define BLINKING_RATE_MS                                                    1

#define Set_data_command 0b00100010
#define Display_ON 0b11110001
#define read_buttons 0b01000010

#define Dig0 0b00000011

int seg7[10]={0b11111100,0b01100000,0b11011010,
0b11110010,0b01100110,0b10110110,
0b10111110,0b11100000,0b11111110,
0b11110110};
int Dig[8]={ 0b00000011, 0b01000011, 0b00100011, 0b01100011, 0b00010011, 0b01010011, 0b00110011, 0b01110011};
int LED[8]={ 0b10000011, 0b11000011, 0b10100011, 0b11100011, 0b10010011, 0b11010011, 0b10110011, 0b11110011};


DigitalOut STB(PB_12);
PortOut tastenanzeige(PortC,0xFF);

SPI anzeige(PB_15,PB_14,PB_13);


void anzeigen(int Nr, int Ziffer)
{
            STB=0;
            anzeige.write(Set_data_command);
            STB=1;  
            
            STB=0;
            anzeige.write(Dig[Nr]);
            anzeige.write(seg7[Ziffer]);
            STB=1;  
}

void ledschalten(int Nr, bool ein)
{
            STB=0;
            anzeige.write(Set_data_command);
            STB=1;  
            STB=0;
            anzeige.write(LED[Nr]);
            if (ein==true) anzeige.write(0x80);
            else anzeige.write(0);
            STB=1;   
}

int main()
{
    int b0, b1, b2, b3;
    DigitalInOut MOSI(PB_15);
    MOSI.mode(OpenDrain);
    STB=1;
    DigitalOut led(LED1);
    anzeige.format(8,3);
    anzeige.frequency(100000);
    
    STB=0;
    anzeige.write(Display_ON);
    STB=1;
    
    while (true) {
        led = !led;
        //thread_sleep_for(BLINKING_RATE_MS);
        for (int i=0;i<8;i++)
        {
            anzeigen(i,i);             
            ledschalten(i,(i%2==0));
             
        }       
        
        STB=0;
        anzeige.write(read_buttons);
        thread_sleep_for(BLINKING_RATE_MS);
        b0=anzeige.write(0xFF);
        b1=anzeige.write(0xFF);
        b2=anzeige.write(0xFF);
        b3=anzeige.write(0xFF);
        tastenanzeige=b0+(b1>>1)+(b2>>2)+(b3>>3);
        //tastenanzeige=anzeige.write(0xFF)+(anzeige.write(0xFF)>>1)+(anzeige.write(0xFF)>>2)+(anzeige.write(0xFF)>>3);
        STB=1;  


    }
}
