/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"
#include "Kanal.h"
#include "eeprom_intern.h"
#include "LCD.h"



// Blinking rate in milliseconds
#define BLINKING_RATE_MS                                                    50
#define automatik 0
DigitalIn TasteP(PA_1);
DigitalIn TasteM(PA_6);
DigitalIn TasteUE(PA_10);
DigitalIn betriebsart(PB_7);
PortIn achsauswahl(PortB,0b111);
AnalogIn speed(PA_0);
lcd mylcd;

struct position
{
    unsigned char w[6]; //6 Positonmen, Wertebereich: 0..180°, für 6 Achsen
    int ms;     //Fahrzeit in ms zur neuen Position
};

position schritt[10]; //Es werden 10 Positionen angefahren

void toEEPROM(void)
{
        EEPROM_WRITE(0, (char*)schritt, sizeof(schritt));
}

void fromEEPROM(void)
{
    int zeiger=0;
        EEPROM_READ(0, (char*)schritt, sizeof(schritt));
}

int main()
{
    int schrittnr=0,achs=0;
    betriebsart.mode(PullDown);
    achsauswahl.mode(PullDown);
    TasteP.mode(PullDown);
    TasteM.mode(PullDown);
    TasteUE.mode(PullDown);
    Kanal* achse[6];    //Der Roboter hat 6 Achsen:
    mylcd.clear();
    mylcd.cursorpos(0);

    for (int i=0;i<6;i++) achse[i]=new Kanal(i); //Die Achsobjekte werden erzeugt
    int dtc=0;
    // Initialise the digital pin LED1 as an output
    DigitalOut led(LED1);   //Diagnose LED auf dem Nukleo
    schritt[0].w[0]=150; //achse[0]: Greifer
    schritt[0].w[1]=90; //achse[1]: Drehachse für den Greifer
    schritt[0].w[2]=90; //achse[2]: Dritter Kipp-Servo, von unten her
    schritt[0].w[3]=90; //achse[3]: Zweiter Kipp-Servo, von unten her
    schritt[0].w[4]=90; //achse[4]: Erster Kipp-Servo auf der Drehachse 
    schritt[0].w[5]=90; //achse[5]: Grundachse, Drehung des Roboters
    schritt[0].ms=1000; //Fahrzeit
    
    schritt[1].w[0]=120;
    schritt[1].w[1]=180;
    schritt[1].w[2]=160;
    schritt[1].w[3]=15;
    schritt[1].w[4]=60;
    schritt[1].w[5]=70;
    schritt[1].ms=1000;

    schritt[2].w[0]=160;
    schritt[2].w[1]=180;
    schritt[2].w[2]=160;
    schritt[2].w[3]=15;
    schritt[2].w[4]=60;
    schritt[2].w[5]=70;
    schritt[2].ms=1000;
    
    schritt[3].w[0]=160;
    schritt[3].w[1]=180;
    schritt[3].w[2]=125;
    schritt[3].w[3]=45;
    schritt[3].w[4]=60;
    schritt[3].w[5]=70;
    schritt[3].ms=1000;
    
    schritt[4].w[0]=160;
    schritt[4].w[1]=180;
    schritt[4].w[2]=125;
    schritt[4].w[3]=45;
    schritt[4].w[4]=60;
    schritt[4].w[5]=150;
    schritt[4].ms=1000;

    schritt[5].w[0]=160;
    schritt[5].w[1]=180;
    schritt[5].w[2]=160;
    schritt[5].w[3]=15;
    schritt[5].w[4]=60;
    schritt[5].w[5]=150;
    schritt[5].ms=1000;
    
    schritt[6].w[0]=120;
    schritt[6].w[1]=180;
    schritt[6].w[2]=160;
    schritt[6].w[3]=15;
    schritt[6].w[4]=60;
    schritt[6].w[5]=150;
    schritt[6].ms=1000;
    schritt[7].ms=1000;
    schritt[8].ms=1000;

    //Grundstellung nch Start des Nucleo
    achse[0]->grundstellung(150);
    achse[1]->grundstellung(90);
    achse[2]->grundstellung(90);
    achse[3]->grundstellung(90);
    achse[4]->grundstellung(90);
    achse[5]->grundstellung(90);
    fromEEPROM();
    mylcd.cursorpos(0);
    mylcd.printf("Schritt=%d  ",schrittnr);
    mylcd.cursorpos(0x40);
    mylcd.printf("a: %d, w: %d  ",achs,schritt[schrittnr].w[achs]);
    while (true) {
        led = !led;
        if (betriebsart==automatik)
        {
            schrittnr=-1;
            for (int j=0;j<8;j++) //Schritte
            {
                mylcd.cursorpos(0);
                mylcd.printf("Schritt=%d  ",j);
                //alle Achsen mit neuen Zielen versorgen und starten
                for (int i=0;i<6;i++)   
                {
                    //Operstion go(´float Zielwinkel, int fahrzeit
                    achse[i]->go(schritt[j].w[i],speed*10000+200);//schritt[j].ms); 
                }
                //warten, dass alle Achsen fertig werden
                for (int i=0;i<6;i++)   
                {
                    //Operation bool isBusy() 
                    //true=Achse bewegt sich noch, false=Achse hat Bewegung beendet
                    while(achse[i]->isBusy()); //-> gleichbedeutend mit .-Operator
                }            
            }
        }
        else
        {
            achs=achsauswahl%6;
            if (schrittnr==-1)  //Init TeachIn
            {
                schrittnr=0;
                mylcd.cursorpos(0);
                mylcd.printf("Schritt=%d  ",schrittnr);
                mylcd.cursorpos(0x40);
                mylcd.printf("a: %d, w: %d  ",achs,schritt[schrittnr].w[achs]);
                for (int j=0;j<6;j++) achse[j]->go(schritt[schrittnr].w[j],1000);
                for (int j=0;j<6;j++)   
                {
                    //Operation bool isBusy() 
                    //true=Achse bewegt sich noch, false=Achse hat Bewegung beendet
                    while(achse[j]->isBusy()); //-> gleichbedeutend mit .-Operator
                }                 
            }
            
            if (TasteP==1) 
            {
                if (schritt[schrittnr].w[achs]<180) schritt[schrittnr].w[achs]++;
                mylcd.cursorpos(0x40);
                mylcd.printf("a: %d, w: %d  ",achs,schritt[schrittnr].w[achs]);
                achse[achs]->go(schritt[schrittnr].w[achs],10);

            }
            if (TasteM==1) 
            {
                if (schritt[schrittnr].w[achs]>0) schritt[schrittnr].w[achs]--;
                mylcd.cursorpos(0x40);
                mylcd.printf("a: %d, w: %d  ",achs,schritt[schrittnr].w[achs]);
                achse[achs]->go(schritt[schrittnr].w[achs],10);
                //for (int j=0;j<6;j++) achse[j]->go(schritt[schrittnr].w[j],25);


            }
            if (TasteUE==1)
            {
                for (int i=0;i<10;i++) schritt[i].ms=1000;
                schritt[0].ms=2000;
                toEEPROM();
                HAL_Delay(20);
                
                schrittnr=(schrittnr+1)%10;
                mylcd.cursorpos(0);
                mylcd.printf("Schritt=%d  ",schrittnr);
                for (int j=0;j<6;j++) achse[j]->go(schritt[schrittnr].w[j],1000);
                for (int j=0;j<6;j++)   
                {
                    //Operation bool isBusy() 
                    //true=Achse bewegt sich noch, false=Achse hat Bewegung beendet
                    while(achse[j]->isBusy()); //-> gleichbedeutend mit .-Operator
                }                 
                while (TasteUE==1);
                HAL_Delay(20);
            }
        }
        
    }
}
