#include "mbed.h"
#include "platform/mbed_thread.h"

#define adresse 0x80
#define EXTCLK 1<<6
#define SLEEP 1<<4
#define AI 1<<5
#define PRE_SCALE 0xFE

#define MODE1 0x0
#define MODE2 0x1
#define LED0_ON_L 0x06

#define SDA D14
#define SCL D15

class Motorino
{
    I2C *motorino;
    static Motorino *meinMotorino;
    
    private:
        Motorino(PinName sda, PinName scl);
        char getLED_ON_L(int nr);
        char getLED_ON_H(int nr);
        char getLED_OFF_L(int nr);
        char getLED_OFF_H(int nr);
        volatile bool busy=false;

    public:
        static Motorino* gibMotorino();
        void WriteToASpecificRegister(char RegAdr,char Wert);
        void setDutyCycle(float dtc, int lednr);
        void init();
        void servo(float pos,int nr,float start=5, float end=10);  //pos 0..180°

};