/** Verwendet Motorino,h
 * mbed Library to use a Motorino shield from Joy IT
 * Copyright (c) 2021 Jörg Sturm
 * Released under the MIT License: http://mbed.org/license/mit
 *
  * Example:
 * @code
 * #include "Kanal.h"

 * Kanal achse(0);  //PWM-Kanal 0 wird für den Servo benutzt
 * int main() {  
 *     while(1)  {
        achse.go(180,1000); //180° in 1000ms
        while (achse.isBusy(); //warte solange beschäftigt
 *     }
 * }
 * @endcode
 */
#include "Motorino.h"

class Kanal
{
    private:
        Motorino *meinMotorino;
        int nr;
        Thread *Bewegung;
        float w_alt, w_ziel;
        float dw;
        int zyklen;
        bool busy=false;
        float start=2, end=12.5;
    public:
    /** Create Kanal Instance
    @param nr 0..15 Kanalnummer
    */
        Kanal(int nr);
        Kanal();
    /** Drehe den Servo um Winkel
    @param w: Winkel 0.. 180°
    @param zeit: Zeit für die Bewegung in ms   
    */
        void go(float w, int zeit);
        void grundstellung(float w);
        void fahre();
    /** Abfrage, ob die Bewegung läuft
    */   
        bool isBusy();
    /** Setzt Tastgrad für 0 und 180°
    @param pStart: Tastgrad für 0° default. 5 für 5%
    @param pEnd:   Tastgrad für 180° default. 10 für 10%
    */    
        void setStartEnd(float pStart, float pEnd);
};