#include "Kanal.h"

Kanal::Kanal(int nr)
{
    this->nr=nr;
    meinMotorino=Motorino::gibMotorino();
    Bewegung=new Thread();
    Bewegung->start(callback(this,&Kanal::fahre));
}

Kanal::Kanal()
{
}

void Kanal::fahre()
{
  while(1)
  {
    if (busy==true)
    {
        printf("gestartet %d\r\n",nr);
        for (int i=0;i<zyklen;i++)
        {   
            w_alt+=dw;
            //printf("w alt %d zyklen %d\r\n",(int)w_alt,zyklen);
            meinMotorino->servo(w_alt,nr,start,end);  //pos 0..180°
            ThisThread::sleep_for(25ms);
        }
        meinMotorino->servo(w_ziel,nr,start,end);  //pos 0..180°
        w_alt=w_ziel;
        busy=false;
    }
    ThisThread::sleep_for(50ms);
  }
}

void Kanal::go(float w, int zeit) //Zeit in ms
{
    printf("gostart %d, %d, %d\r\n",(int)w,zeit,(int) busy);
    if (busy==false)
    {        
        zyklen=zeit/25;
        dw=(w-w_alt)/zyklen;
        w_ziel=w;
        busy=true;
    }
        
}

void Kanal::grundstellung(float w)
{
    meinMotorino->servo(w,nr,start,end);  //pos 0..180°
    w_alt=w;
}

bool Kanal::isBusy()
{   
    //if (busy==false) Bewegung.terminate();
    return busy;
}

void Kanal::setStartEnd(float pStart, float pEnd)
{
    if (pStart>0 && pStart<100 && pStart<pEnd) start=pStart;
    if (pEnd>0 && pEnd<100 && pStart<pEnd) end=pEnd;
}

