
#include "mbed.h"
#include "PubSubClient.h"   //MQTT- Bibliothek
#include "LCD.h"



#define DHTLIB_OK                0
#define DHTLIB_ERROR_CHECKSUM   -1
#define DHTLIB_ERROR_TIMEOUT    -2

Timer tmr;
lcd mylcd;


PubSubClient client;        //Deklaration des MQTT-Clients
DigitalInOut data_pin(PB_0);  //Anschluss S (Data)
//Anschluss - an GND
//mittlerer Anschluss an 3,3V

int humidity;
int temperature;

//########################################
// DHT11 Library
//########################################
int dht_read(void){
    
    // BUFFER TO RECEIVE
    uint8_t bits[5];
    uint8_t cnt = 7;
    uint8_t idx = 0;
    
    tmr.stop();
    tmr.reset();

    // EMPTY BUFFER
    for(int i=0; i< 5; i++) bits[i] = 0;

    // REQUEST SAMPLE
    data_pin.output();
    data_pin.write(0);
    wait_us(18000);
    data_pin.write(1);
    wait_us(40);
    data_pin.input();

    // ACKNOWLEDGE or TIMEOUT
    unsigned int loopCnt = 20000;
    
    while(!data_pin.read())if(!loopCnt--)return DHTLIB_ERROR_TIMEOUT;

    loopCnt = 20000;
    
    while(data_pin.read())if(!loopCnt--)return DHTLIB_ERROR_TIMEOUT;

    // READ OUTPUT - 40 BITS => 5 BYTES or TIMEOUT
    for(int i=0; i<40; i++){
        
        loopCnt = 20000;
        
        while(!data_pin.read())if(loopCnt-- == 0)return DHTLIB_ERROR_TIMEOUT;

        //unsigned long t = micros();
        tmr.start();

        loopCnt = 20000;
        
        while(data_pin.read())if(!loopCnt--)return DHTLIB_ERROR_TIMEOUT;

        if(tmr.read_us() > 40) bits[idx] |= (1 << cnt);
        
        tmr.stop();
        tmr.reset();
        
        if(cnt == 0){   // next byte?
        
            cnt = 7;    // restart at MSB
            idx++;      // next byte!
            
        }else cnt--;
        
    }

    // WRITE TO RIGHT VARS
    // as bits[1] and bits[3] are allways zero they are omitted in formulas.
    humidity    = bits[0]; 
    temperature = bits[2]; 

    uint8_t sum = bits[0] + bits[2];  

    if(bits[4] != sum)return DHTLIB_ERROR_CHECKSUM;
    
    return DHTLIB_OK;
    
}

char buffer[20];

//########################################
// End of DHT11 Library
//########################################

//Subscribe-Callbacks
void subscribeCallback(MessageData& mymessage)
{
    mylcd.cursorpos(0);
    //Der Inhalt einer Botschaft (payload) kann als String mit gibPayload 
    //abgerufen werden
    mylcd.printf("%s      ",client.gibPayload(mymessage).c_str());
}

void subscribeCallback2(MessageData& mymessage)
{
    mylcd.cursorpos(0x40);
    mylcd.printf("%s ",client.gibPayload(mymessage).c_str());
}


int main(void){
    
    mylcd.clear();
    mylcd.cursorpos(0);
    
    mylcd.printf("Nucleo - DHT11");
    
    client.connect((char*)"joerg"); //Verbinde Client mit ID 
    //Client für topic einschreiben
    client.subscribe("MBED/oehringen/temp", QOS0, subscribeCallback); 
    client.subscribe("MBED/oehringen/hum", QOS1, subscribeCallback2); 
    
    for(;;){
       client.loop();  //Auf neue Botschaften prüfen
       int fehler=dht_read();
        //Temperatur veröffentlichen
        sprintf(buffer, "Temp=%2dC", temperature); //Temperaturwert in buffer speichern
        client.publish("MBED/oehringen/temp", buffer, QOS1,true); //unter Topic veröffentlichen
        //HAL_Delay(200);
        //Luftfeuchte veröffentlichen
        sprintf(buffer, "Luftfeuchte=%d", humidity); //diag in buffer speichern
        client.publish("MBED/oehringen/hum", buffer,QOS2,true); //unter Topic veröffentlichen
            


        wait_us(500000);
            

    
    }
    
}
