#ifndef _MQTTNETWORK_H_
#define _MQTTNETWORK_H_

#include "EthernetInterface.h"
#include "TCPSocket.h"

class   MQTTNetwork
{
public:
    MQTTNetwork(EthernetInterface* aNetwork) :
    network(aNetwork),
    socket(new TCPSocket)
    {}

    ~   MQTTNetwork()                                       { delete socket; }
    int read(unsigned char* buffer, int len, int timeout)   { return socket->recv(buffer, len); }
    int write(unsigned char* buffer, int len, int timeout)  { return socket->send(buffer, len); }
    int connect(const char* hostname, uint16_t port)
    {
        SocketAddress   addr;

        socket->open(network);
        addr.set_ip_address(hostname);
        addr.set_port(port);
        return socket->connect(addr);
    }
    int disconnect()    { return socket->close(); }
private:
    EthernetInterface*  network;
    TCPSocket*          socket;
};
#endif // _MQTTNETWORK_H_
