/** Library für Multifunctionshield Nucleo-F401RE
 *
 * Example:
 * @code
 * #include "MFS.h"
 * MFS mfs;
 * Ticker meinTicker;
 *void anzeigen()
 *{
 *   int ausgabe=1234;
 *   
 *   switch(digit)
 *   {
 *       case 0x10: mfs=(digit<<8)+seg7[ausgabe%10];
 *           digit=0x20;
 *           break;
 *       case 0x20: mfs=(digit<<8)+seg7[(ausgabe/10)%10];
 *           digit=0x40;
 *           break;
 *       case 0x40: mfs=(digit<<8)+seg7[(ausgabe/100)%10];
 *           digit=0x80;
 *           break;
 *       case 0x80: mfs=(digit<<8)+seg7[(ausgabe/1000)%10];
 *           digit=0x10;
 *           break;
 *   }
 *}
 * int main() {  
 *     //mfs=d0ss;  mit d=Digit: 0b0001 Einerstelle, 0b0010 Zehnerstelle
 *     // 0b0100 Hunderterstelle, 0b1000 Tausenderstelle
 *     // ss Siebensegmentcode
 *     while(1)  {
 *     }
 * }
 * @endcode
 */
#include "stm32f4xx_hal.h"
#include "mbed.h"

#define USART_TX_Pin GPIO_PIN_2
#define USART_TX_GPIO_Port GPIOA
#define USART_RX_Pin GPIO_PIN_3
#define USART_RX_GPIO_Port GPIOA
#define beep_Pin GPIO_PIN_3
#define beep_GPIO_Port GPIOB
#define latch_Pin GPIO_PIN_5
#define latch_GPIO_Port GPIOB

class MFS
{   
    private:
    uint8_t dieAuswahl=0;
    uint8_t dieSegmente=0xFF;
    char seg7[10]={0xFC,0x60,0xDA, 0xF2, 0x66, 0xB6, 0xBE, 0xE0, 0xFE, 0xF6};
    USART_HandleTypeDef husart1;
    public:
    void operator=(unsigned int wert);
    operator int(void);
    MFS(void);
    void siebensegment(uint8_t wert);
    void siebensegment(uint8_t awert,uint8_t wert);
    void bcd(int wert);
    void bcd(uint8_t awert, int wert);
    void auswahl(uint8_t wert);
    private:
    void send(void);
};