/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"
#include "MFS.h"

// Blinking rate in milliseconds
#define BLINKING_RATE_MS                                                    500

MFS mfs;
Ticker meinTicker;
Ticker MotorTicker;
int analog;
char seg7[10]={0x3F,0x06,0x5B,0x4F,0x66,0x6D,0x7D,0x07,0x7F,0x6F};
                            

DigitalOut summer(PB_3);

char schritt[4]={0b0011,0b0110,0b1100,0b1001};

PortOut Motor(PortC,0xF);

int digit=0x10;
int pos=0;

void drehen()
{
    Motor=schritt[pos];
    pos=(pos+1)%4;
}


void anzeigen()
{
    int ausgabe=analog;
    
    switch(digit)
    {
        case 0x10: mfs=(digit<<8)+seg7[ausgabe%10];
            digit=0x20;
            break;
        case 0x20: mfs=(digit<<8)+seg7[(ausgabe/10)%10];
            digit=0x40;
            break;
        case 0x40: mfs=(digit<<8)+seg7[(ausgabe/100)%10];
            digit=0x80;
            break;
        case 0x80: mfs=(digit<<8)+seg7[(ausgabe/1000)%10];
            digit=0x10;
            break;

    }
    //mfs=0x80FC;
}

int main()
{
    // Initialise the digital pin LED1 as an output
    DigitalOut led(LED1);
    AnalogIn Poti(PA_0);
    meinTicker.attach_us(&anzeigen,1000);
    MotorTicker.attach_us(&drehen,10000);
    summer=1;
    while (true) {
        led = !led;
        thread_sleep_for(BLINKING_RATE_MS);
        analog=Poti*9999;
        if (analog<1000) summer=0;
        else summer=1;
        MotorTicker.attach_us(&drehen,analog*2);
    }
}
