#include "mbed.h"
#include "TextLCD.h"

Serial pc(SERIAL_TX, SERIAL_RX); 
AnalogIn button(A0);    // Init button (SELECT, LEFT, UP, DOWN, RIGHT)
// LCD (RS, E, D4, D5, D6, D7);
TextLCD lcd(D8, D9, D4, D5, D6, D7);
//PwmOut backlight(D10);  // Backlight LCD
DigitalOut led(LED1);


int main() {
    
    // Set backlight period and duty cycle 
    //backlight.period(0.002);
    //backlight = 1;

    
    lcd.cls();                      // Clear LCD
    lcd.locate(1,0);                // Set locate (1 row, 2 column)
    lcd.printf("LCD Key Shield");
    wait(1);
    
    int meas;
    
    while(1) {
        led = (led == 1) ? 0 : 1;

        meas = button * 1000; // Read the analog input value (value from 0.0 to 1.0) and convert to int value (from 0 to 1000)
        
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("Press button");
        lcd.locate(0,1);
        
        if (meas < 50) { 
            lcd.printf("BUTTON: Right ");
            //backlight = 0.5;        // Set 50% backlight 
        }
        else if (meas < 250) { 
            lcd.printf("BUTTON: Up");
            //backlight = 1;          // Power ON backlight
        } 
        else if (meas < 530){ 
            lcd.printf("BUTTON: Down");
            //backlight = 0;          // Power OFF backlight
        } 
        else if (meas < 780&&meas>735){ 
            lcd.printf("BUTTON: Left"); 
        } 
        else if (meas > 950){ 
            lcd.printf("BUTTON: Select");
        }
        pc.printf("BUTTON: %4d\n", meas);
        
        wait(0.1);
    }
}