/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"

DigitalOut IRD1(PA_6);
DigitalOut IRD2(PA_7);
DigitalOut linksR(PC_0);
DigitalOut linksS(PC_1);
DigitalOut rechtsR(PC_2);
DigitalOut rechtsS(PC_3);
DigitalIn sens1(PC_8);
DigitalIn sens2(PC_9);

void TIM6_IRQHandler(void)
{
    IRD1=!IRD1;
    IRD2=!IRD2;
    TIM6->SR=0;
    HAL_NVIC_ClearPendingIRQ(TIM6_IRQn);
}

/* TIM6 init function */
void TIM6_Init(void)
{
    RCC->APB1ENR|=0b10000;  //Clock Enable
    TIM6->PSC=0;            //Prescaler 32MHz
    TIM6->ARR=416;         //Autoreload 5000*100µs = 0,5s
    TIM6->DIER=1;           //UIE = 1 (Update Interrupt Enable)
    TIM6->SR=0;             //UIF =0 (Update Interrupt Flag)
    TIM6->CR1=1;            //CEN=1 (Counter Enable)
   /* TIM6_IRQn interrupt configuration */
    NVIC_SetVector(TIM6_IRQn, (uint32_t)&TIM6_IRQHandler);
    HAL_NVIC_EnableIRQ(TIM6_IRQn);

}




int main()
{

    TIM6_Init();
    sens1.mode(PullUp);
    sens2.mode(PullUp);
    while (true) {
        linksS=sens1;
        linksR=!linksS;
        rechtsS=sens2;
        rechtsR=!rechtsS;

    }
}
