/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"

DigitalIn TE(PB_4);
DigitalIn TA(PB_3);
DigitalIn LS(PB_7);
InterruptIn HALT(PB_0);
PortOut ausgaenge(PortC,0x0F);
DigitalOut Schieber(PC_0);
DigitalOut Motor(PC_1);
DigitalOut Luefter(PC_2);
DigitalOut Pumpe(PC_3);

DigitalOut warnlampe(PC_7);
InterruptIn impuls(PA_1);
volatile int z=0;


DigitalOut test(PC_6);



void HALT_ISR()
{
    unsigned char merker;
    merker=ausgaenge;
    ausgaenge=0;
    while(HALT==0);
    ausgaenge=merker;
}

void impulsISR()
{
    z++;
    //test=1;
}

void isrTIM6()
{
    test=!test;
    if (z<50) 
    {
        warnlampe=1;
    }
    else
    {
        warnlampe=0;
    }
    z=0;
    TIM6->SR=0;     //Überlaufflag zurücksetzen
    HAL_NVIC_ClearPendingIRQ(TIM6_IRQn);    //Pendingbit NVIC zurücksetzen
}

void init() {
  //Für die Demoplatine sind Pulldowns erfotderlich
  TE.mode(PullDown);
  TA.mode(PullDown);
  LS.mode(PullDown);
  HALT.mode(PullDown);

  //für die Abiaufgabe
  HALT.fall(&HALT_ISR);
  HALT.enable_irq();
  __enable_irq();
  
  //Lüfterüberwachung
  impuls.fall(&impulsISR);
  impuls.enable_irq();
  //Timer TIM6
  RCC->APB1ENR |= 0b10000; //TIM6 mit Takt versorgen
  TIM6->PSC=31999;  //Prescaler für 1ms 
  TIM6->CNT=0;      //Zähler bei 0 starten
  TIM6->ARR=999;    //Autoreload für 1s (0.999 = 1000 Zähltakte
  TIM6->SR=0;       //Überlaufflag zurücksetzen
  TIM6->DIER=1;       //Imterrupt freigeben Timer
  NVIC_SetVector(TIM6_IRQn, (uint32_t)&isrTIM6);    //ISR zuordnen
  HAL_NVIC_EnableIRQ(TIM6_IRQn);    //Interrupt freigeben NVIC
  TIM6->CR1=1;      //Timer starten
}


int main()
{
    init();

    while (true) {
      ausgaenge=0b0000;
      while (TE==0);
      ausgaenge=0b1110;
      while (LS==0); 
      ausgaenge=0b1111;
      while (TA==0); 
      ausgaenge=0b0111;
      while (LS==1);  
    }
}
