/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"

InterruptIn LS1(PA_1);
InterruptIn LS2(PA_6);
DigitalIn ResetBehaelter(PA_10);

PortIn waage(PortB,0xFF);
int sollwert=128;

PortOut ausgaenge(PortC,0b11111);
volatile int anz=0;




void warte1s()
{
    RCC->APB1ENR |= 0b10000; //TIM6 mit Takt versorgen
    TIM6->PSC=31999;        //Prescaler für 1ms
    TIM6->CNT=0;            //Counter mit 0 starten
    TIM6->ARR=999;          //Autoreload für 1s (1000ms Zählwert von 0-999
    TIM6->SR=0;             //Überlaufflag zurücksetzen
    TIM6->CR1=1;            //setzt CEN auf 1 => startet den Timer
    while (TIM6->SR==0);    //Warten auf Überlauf
    TIM6->CR1=0;            //setzt CEN auf 0 => stoppt den Timer
}



void isrLS1()
{
    ausgaenge=ausgaenge&0b11101;
    warte1s();
    if (waage<sollwert)
    {
       ausgaenge=ausgaenge|0b00001;
    }
    else
    {
        ausgaenge=ausgaenge&0b11110;   
    }
    ausgaenge=ausgaenge|0b00010;
}
DigitalOut test(PC_7);
char ampel[5]={0b00010,0b10010,0b01010,0b01110,0b00100};
void isrLS2()
{
   anz++;
   ausgaenge=ampel[anz];
   test=1;
}    
void initISR()
{
    LS1.mode(PullDown);
    LS2.mode(PullDown);
    ResetBehaelter.mode(PullDown);
    waage.mode(PullDown);
    LS1.fall(&isrLS1);
    LS2.fall(&isrLS2);
}




int main()
{
    ausgaenge=0b00010;
    initISR();

    while (true) {
        if (ResetBehaelter==1)
        {
            ausgaenge=0b00010;
            anz=0;
        }
    }
}
