/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"
#include "LCD.h"
#include <Callback.h>

// Blinking rate in milliseconds
#define BLINKING_RATE_MS                                                    500

BufferedSerial hc05(PB_10,PB_11,9600);
DigitalOut links1(PA_8);
DigitalOut links2(PA_9);
DigitalOut rechts1(PA_10);
DigitalOut rechts2(PA_11);
lcd mylcd;
char c;



int main()
{
    char daten[6];

    mylcd.clear();
    while (true) {
        if (hc05.readable()) 
        {
            hc05.read(daten,1);
            mylcd.cursorpos(0x40);
            mylcd.printf("%d",daten[0]);
            switch(daten[0])
            {
                case 'U':links1=1;links2=0;break;
                case 'X':links1=0;links2=0;break;
                case 'D':links1=0;links2=1;break;
                case 'V':rechts2=1;rechts1=0;break;
                case 'Y':rechts2=0;rechts1=0;break;
                case 'E':rechts2=0;rechts1=1;break;
                case 'W':links1=1;links2=0;rechts2=1;rechts1=0;break;
                case 'Z':links1=0;links2=0;rechts2=0;rechts1=0;break;
                case 'F':links1=0;links2=1;rechts2=0;rechts1=1;break;
            }
        }
        //thread_sleep_for(BLINKING_RATE_MS);
    }
}
