/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"
#include "LCD.h"
#include <Callback.h>

// Blinking rate in milliseconds
#define BLINKING_RATE_MS                                                    500

BufferedSerial hc05(PB_6,PB_7,9600);
PortOut anzeige(PortC,0xFF);
DigitalIn taste(PA_6);
lcd mylcd;
char c;


int main()
{
    char daten[6]="Hallo";
    // Initialise the digital pin LED1 as an output
    DigitalOut led(PA_5);
    taste.mode(PullDown);
    mylcd.clear();
    mylcd.cursorpos(0);
    mylcd.printf("Hallo");
    while (true) {
        led = !led;
            daten[0]='*';
            daten[1]='T';
            daten[2]='x';            
            if (taste) daten[3]='y';
            else daten[3]='z';
            daten[4]='*';
            
            hc05.write(daten,4);
        if (hc05.readable()) 
        {
            hc05.read(&c,1);
            mylcd.printf("%c",c);

        }
        thread_sleep_for(BLINKING_RATE_MS);
    }
}
