/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"
#include "LCD.h"
#include "string"

#include "VH.h"

VH myVH;



PortOut Klappen(PortC,0b11);
#define Stellung1 0
#define Stellung2 1
#define Stellung3 2


DigitalOut FlaschenbandStart(PC_2);
DigitalOut KistenbandStart(PC_3);
DigitalOut GreiferStarten (PC_6);

DigitalIn Flasche1Sensor(PB_0);
DigitalIn Flasche2Sensor(PB_1);
DigitalIn Flasche3Sensor(PB_2);
DigitalIn Kiste1Sensor(PB_3);
DigitalIn Kiste2Sensor(PB_4);
DigitalIn Kiste3Sensor(PB_5);
DigitalIn GreiferFertig(PB_6);
DigitalIn verbunden(PB_7);



lcd mylcd;

void textzeile2(char* text)
{
    mylcd.cursorpos(0);
    mylcd.printf("%s",text);
}

void dualaus3(unsigned char x)
{
    mylcd.cursorpos(0x40);
    for (int i=0;i<8;i++)
    mylcd.printf("%d",(x>>(7-i))&1);
}

int main()
{

    mylcd.clear();
    Flasche1Sensor.mode(PullUp);
    Flasche2Sensor.mode(PullUp);
    Flasche3Sensor.mode(PullUp);
    Kiste1Sensor.mode(PullUp);
    Kiste2Sensor.mode(PullUp);
    Kiste3Sensor.mode(PullUp);;
    GreiferFertig.mode(PullUp);;
    verbunden.mode(PullUp);
    
    FlaschenbandStart=1;
    KistenbandStart=1;
    GreiferStarten=1;
    

    while (true) {
    while(verbunden==1) {dualaus3(GPIOB->IDR&0xFF);textzeile2((char*)"Warten verbunden ");}
    while(1)
    {
        Klappen=Stellung1;
        FlaschenbandStart=0;  
        
        while (Flasche1Sensor==1) {dualaus3(GPIOB->IDR&0xFF);textzeile2((char*)"Warten Flasche1 ");}
        Klappen=Stellung2;
        while (Flasche2Sensor==1){dualaus3(GPIOB->IDR&0xFF); textzeile2((char*)"Warten Flasche2 ");}
        /*Klappen=Stellung3;
        while (Flasche3Sensor==1){dualaus3(GPIOB->IDR&0xFF); textzeile2((char*)"Warten auf Flasche3 ");}
        Klappen = Stellung1;
        FlaschenbandStart=1;
        textzeile2("Flaschenband gestoppt ");
        KistenbandStart=0;
        while (Kiste1Sensor==1){dualaus3(GPIOB->IDR&0xFF); textzeile2("Warten auf Kiste1    ");}
        KistenbandStart=1;
        GreiferStarten=0;
        HAL_Delay(200);
        GreiferStarten=1;
        while(GreiferFertig==1) {dualaus3(GPIOB->IDR&0xFF); textzeile2("Warten auf Greifer   ");}
        FlaschenbandStart=0;
        while (Flasche1Sensor==1) {dualaus3(GPIOB->IDR&0xFF); textzeile2("Warten auf Flasche1 ");}
        Klappen= Stellung2;
        while (Flasche2Sensor==1) {dualaus3(GPIOB->IDR&0xFF); textzeile2("Warten auf Flasche2 ");}
        Klappen=Stellung3;
        while (Flasche3Sensor==1) {dualaus3(GPIOB->IDR&0xFF); textzeile2("Warten auf Flasche3 ");}
        Klappen=Stellung1;
        FlaschenbandStart=1;
        textzeile2("Flaschenband gestoppt ");
        KistenbandStart=0;
        while (Kiste2Sensor==1){dualaus3(GPIOB->IDR&0xFF); textzeile2("Warten auf Kiste2    ");}
        KistenbandStart=1;
        GreiferStarten=0;
        HAL_Delay(200);
        GreiferStarten=1;
        while(GreiferFertig==1) {dualaus3(GPIOB->IDR&0xFF); textzeile2("Warten auf Greifer   ");}
        FlaschenbandStart=0;
        while (Flasche1Sensor==1) textzeile2("Warten auf Flasche1 ");
        Klappen=Stellung2;
        while (Flasche2Sensor==1) textzeile2("Warten auf Flasche2 ");
        Klappen=Stellung3;
        while (Flasche3Sensor==1) textzeile2("Warten auf Flasche3 ");
        Klappen=Stellung1;
        FlaschenbandStart=1;
        textzeile2("Flaschenband gestoppt ");
        KistenbandStart=0;
        while (Kiste3Sensor==1)textzeile2("Warten auf Kiste3    ");
        KistenbandStart=1;
        GreiferStarten=0;
        HAL_Delay(200);
        GreiferStarten=1;
        while(GreiferFertig==1) textzeile2("Warten auf Greifer   ");
        KistenbandStart=0;
        HAL_Delay(3000);
        KistenbandStart=1;
        */
    }   

    }
}
