#include "ESP8266Webserver.h"
//#include "string"

ESP8266Webserver::ESP8266Webserver()
{
    bool erg;
    //HAL_Delay(1000);
    DigitalOut ch_pd(CH_PD);
    DigitalOut rst(RST); 
    ch_pd=1;
    rst=0;
    HAL_Delay(100);
    rst=1;
    hs_count=0;
    clientIdx=0;
    if (pDebug) printf("\nATCmdParser with ESP8266 example");
    port=Port;
    
    dbg=pDebug;
    _serial = new BufferedSerial(tx,rx, ESP8266_DEFAULT_BAUD_RATE);
    _parser = new ATCmdParser(_serial, "\r\n",1000);
    _parser->debug_on(true);

    _parser->set_timeout(2000);
    
//AT
    if (pDebug) printf("\nATCmdParser: AT\r\n");
    _parser->send("AT");
    
    if (_parser->recv("OK")) {
        if (pDebug) printf("\nAntw.: OK\r\n");
    } else {
        printf("\nATCmdParser: AT OK failed\r\n");
    }

    if (station==true) 
    { 
        listAPs();
        printf("%s",ipadr);
    }
    else {
        _parser->send("ATE0");
        strcpy(ipadr,ip);
    
        if (pDebug) printf("\nATCmdParser: //AT+CWMODE=2 \r\n");
        
        _parser->send("AT+CWMODE=2");
        HAL_Delay(1000);
        
        if (_parser->recv("OK")) {
            if (pDebug) printf("\nAntw.: OK\r\n");
        } else {
            printf("\nATCmdParser: AT+CWMODE=2 OK failed\r\n");
        }

//AT+CWMODE? 
    if (pDebug) printf("\nATCmdParser: //AT+CWMODE? \r\n");

    _parser->send("AT+CWMODE?");
    
    if (_parser->recv("OK")) {
        if (pDebug) printf("\nAntw.: OK\r\n");
    } else {
        printf("\nATCmdParser: AT+CWMODE? OK failed\r\n");
    }
    
    
//AT+CIPAP="192.168.5.1","192.168.5.1","255.255.255.0"
        if (pDebug) printf("\nATCmdParser: //AT+CIPAP=\"%s\",\"%s\",\"%s\" \r\n",ipad.c_str(),ipad.c_str(),netzmaske);
        do
        {
            _parser->send("AT+CIPAP=\"%s\",\"%s\",\"%s\"",ipad.c_str(),ipad.c_str(),netzmaske);
            erg=_parser->recv("OK");
            if (erg==true) {
                if (pDebug) printf("\nAntw.: OK\r\n");
            } else {
                printf("\nATCmdParser: AT+CIPAP OK failed\r\n");
                HAL_Delay(1000);
            }           
        }
        while (erg==false);
        
     
    
//AT+CIPMUX=1
    if (pDebug) printf("\nATCmdParser: //AT+CIPMUX=1");
    _parser->send("AT+CIPMUX=1");
    
    if (_parser->recv("OK")) {
        if (pDebug) printf("\nAntw.: OK\r\n");
    } else {
        printf("\nATCmdParser: AT+CIPMUX=1 OK failed\r\n");
    }
    }
}

int ESP8266Webserver::on(const char* handlestring,Callback< void()> func)
{
  if (hs_count>9) return -1;
  else
  {
    strcpy(hs[hs_count],handlestring); 
    if (dbg) printf("\r\n\r\n%s, %s\r\n",handlestring,hs[hs_count]);
    cbs[hs_count]=func;
    hs_count++;
    return 0;
  }
    
}

int ESP8266Webserver::begin(void)
{
//AT+CIPSERVER=1,80
    if (dbg) printf("\nATCmdParser: //AT+CIPSERVER=1,%d",Port);
    _parser->send("AT+CIPSERVER=1,%d",Port);
    if (_parser->recv("OK")) {
        if (dbg) printf("\nAntw.: OK\r\n");
        return 0;
    } else {
        printf("\nATCmdParser: AT+CIPSERVER=1 OK failed\r\n");
        return -1;
    }
}

//durchsucht recbuf nach suchstring
bool ESP8266Webserver::beinhaltet(char* suchstring)
{
    char* referer;
    char* fundort;
    char* favicon;
    char* post;
    post=strstr(recbuf,"POST");
    favicon=strstr(recbuf,"favicon");
    if (favicon!=NULL) return true;
    referer=strstr(recbuf,"Referer");
    fundort=strstr(recbuf, suchstring);
    if (strstr(recbuf,"ERROR")==NULL)
    if( fundort != NULL&&(fundort<referer||referer==NULL)) return true;
    if (fundort != NULL&&post!=NULL) return true;
    return false;
}

int ESP8266Webserver::handleClient(void)
{
    char favicon[]="favicon.ico";
    const char ico[1150]={
0x00,0x00,0x01,0x00,0x01,0x00,0x10,0x10,0x00,0x00,0x01,0x00,0x20,0x00,0x68,0x04,0x00,0x00,
0x16,0x00,0x00,0x00,0x28,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x01,0x00,
0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0xFF,
0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,
0x00,0xFF,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x07,0x03,0x91,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x07,0x03,0x91,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0xFF,
0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,
0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,
0x07,0x03,0x91,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x00,0x00,0x00,0xFF,0x07,0x03,0x91,0xFF,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0xFF,
0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0x07,0x03,
0x91,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x07,0x03,0x91,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,
0x91,0xFF,0x07,0x03,0x91,0xFF,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0xFF,
0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0x07,0x03,0x91,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x07,0x03,0x91,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0xFF,
0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,0x00,0x00,
0x00,0xFF,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,0x00,0x00,
0x00,0xFF,0x00,0x00,0x00,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,
0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,0x00,0x00,0x00,0xFF,0x00,0x00,
0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0x07,0x03,0x91,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,
0x91,0xFF,0x07,0x03,0x91,0xFF,0xFF,0xFF,0xFF,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,
0x07,0x03,0x91,0xFF,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0xFF,
0x07,0x03,0x91,0xFF,0xFF,0xFF,0xFF,0xFF,0x07,0x03,0x91,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,0x00,0x00,0x00,0xFF,
0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x00,0x00,0x00,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x07,0x03,0x91,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x07,0x03,0x91,0xFF,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,
0x91,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,0x00,0x00,
0x00,0xFF,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0xFF,
0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,
0x91,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,0xFF,0xFF,0xFF,0xFF,0x07,0x03,0x91,0xFF,
0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0xFF,0xFF,0xFF,
0xFF,0xFF,0x00,0x00,0x00,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,
0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,
0x91,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,
0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,
0x91,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,
0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,
0x91,0xFF,0x07,0x03,0x91,0xFF,0x07,0x03,0x91,0xFF,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0xFF,
0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0xFF,0x00,0x00,
0x00,0xFF,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0xFF,
0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0xFF,0x00,0x00,
0x00,0xFF,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00

 };
    int value,value2;
    static int diag=0;
    if (_serial->readable())
        {   
            if (_parser->recv("+IPD,%d,%d:",&clientID[clientIdx],&value2)) 
            {
                if (dbg) printf("\r\n >>> Client ID=%d, Anzahl=%d",clientID[clientIdx],value2);
                _parser->read(recbuf, value2);


                if (dbg) printf("\r\nBuf=\n%s\n\n",recbuf);

                if (beinhaltet(favicon))
                {
                    printf("\n\nfavicon request %d\n\n",diag);
                    diag++;
                    send(404,"image/x-icon","");
                }
                else
                {
                    gefunden=false;
                    for (int i=0;i<hs_count&&!gefunden;i++)
                    {                    
                        if (beinhaltet(hs[i]))
                        {                       
                            (cbs[i])();                       
                            gefunden=true;
                        }
                    } 
                }
                if (dbg) for (int i=0;i<hs_count;i++)
                {
                    printf("\r\n%s\r\n",hs[i]);
                }               
                if (dbg) printf("\r\n>>> Got\r\n");
            }          
        }

    return 0;
}


int ESP8266Webserver::send(int HTTPStatus,const char* Mimetype, string webseite)
{
    return ESP8266Webserver::send(HTTPStatus,Mimetype, webseite.c_str());
}

int ESP8266Webserver::send(int HTTPStatus,const char* Mimetype, const char* webseite)
{
    char hilf[40];
    char statustext[40];
    
    sprintf(statustext,"OK");
 
    switch (HTTPStatus)
    {   
    case 404: sprintf(statustext,"Not Found"); break;
    case 206: sprintf(statustext,"Partial Content"); break;
    case 401: sprintf(statustext,"Unauthorized"); break;
    case 403: sprintf(statustext,"Forbidden"); break;
    case 307:
    case 302: sprintf(statustext,"Moved Temporarily"); break;
    case 301: sprintf(statustext,"Moved Permanently"); break;
    case 304: sprintf(statustext,"Not Modified"); break;
    
    }
    
    
    //printf("\r\nHallo\r\n");
    Aufrufe++;
    switch (HTTPStatus)
    {
    case 206:
    case 200: sprintf(sendstring,"HTTP/1.1 %d %s\n",HTTPStatus,statustext); 
        strcat(sendstring,"Date: Wed, 23 Apr 2021 04:36:25 GMT\n");
        strcat(sendstring,"Connection: close\n");
        strcat(sendstring,"Content-Type: ");
        strcat(sendstring,Mimetype);
        strcat(sendstring,"\n");
        sprintf(hilf,"%d",strlen(webseite));
        strcat(sendstring,"Content-Length: ");
        strcat(sendstring,hilf);
        strcat(sendstring,"\n\n");
        strcat(sendstring,webseite);
        break;
       
    case 301:
    case 302: sprintf(sendstring,"HTTP/1.1 %d %s\n",HTTPStatus,statustext); 
        strcat(sendstring,"Date: Wed, 23 Apr 2021 04:36:25 GMT\n");
        strcat(sendstring,"Connection: close\n");
        strcat(sendstring,"Location: http://www.gsoe.de/");
        strcat(sendstring,"\n\n");
        break;   
        
    default: sprintf(sendstring,"HTTP/1.1 %d %s\n",HTTPStatus,statustext); 
        strcat(sendstring,"Date: Wed, 23 Apr 2021 04:36:25 GMT\n");
        strcat(sendstring,"Connection: close\n");
       // strcat(sendstring,"Content-Type: ");
       // strcat(sendstring,Mimetype);
       // strcat(sendstring,"\n");
        strcat(sendstring,"Content-Length: 0");
        strcat(sendstring,"\n\n");
        break;
    }

    if (dbg) printf("len=%d, inhalt=\n%s",strlen(sendstring),sendstring);

    _parser->debug_on(true);
    _parser->send("AT+CIPSEND=%d,%d",clientID[clientIdx],strlen(sendstring));  
    _parser->debug_on(false);          
    _parser->write(sendstring,strlen(sendstring));  
    HAL_Delay(200);                
    _parser->send("AT+CIPCLOSE=%d",clientID[clientIdx]);
    return 0;
}

int ESP8266Webserver::send(int HTTPStatus,const char* Mimetype, const char* webseite, int length)
{
    char hilf[40];
    char statustext[40];
    
    sprintf(statustext,"OK");
 
    switch (HTTPStatus)
    {   
    case 404: sprintf(statustext,"Not Found"); break;
    case 206: sprintf(statustext,"Partial Content"); break;
    case 401: sprintf(statustext,"Unauthorized"); break;
    case 403: sprintf(statustext,"Forbidden"); break;
    case 307:
    case 302: sprintf(statustext,"Moved Temporarily"); break;
    case 301: sprintf(statustext,"Moved Permanently"); break;
    case 304: sprintf(statustext,"Not Modified"); break;
    
    }
    
    
    //printf("\r\nHallo\r\n");
    Aufrufe++;
    switch (HTTPStatus)
    {
    case 206:
    case 200: sprintf(sendstring,"HTTP/1.1 %d %s\n",HTTPStatus,statustext); 
        strcat(sendstring,"Date: Wed, 23 Apr 2021 04:36:25 GMT\n");
        strcat(sendstring,"Connection: close\n");
        strcat(sendstring,"Content-Type: ");
        strcat(sendstring,Mimetype);
        strcat(sendstring,"\n");
        sprintf(hilf,"%d",length);
        strcat(sendstring,"Content-Length: ");
        strcat(sendstring,hilf);
        strcat(sendstring,"\n\n");
        strcat(sendstring,webseite);
        break;
        
    default: sprintf(sendstring,"HTTP/1.1 %d %s\n",HTTPStatus,statustext); 
        strcat(sendstring,"Date: Wed, 23 Apr 2021 04:36:25 GMT\n");
        strcat(sendstring,"Connection: close\n");
       // strcat(sendstring,"Content-Type: ");
       // strcat(sendstring,Mimetype);
       // strcat(sendstring,"\n");
        strcat(sendstring,"Content-Length: 0");
        strcat(sendstring,"\n\n");
        break;
    }

    if (dbg) printf("len=%d, inhalt=\n%s",strlen(sendstring),sendstring);

    _parser->debug_on(true);
    _parser->send("AT+CIPSEND=%d,%d",clientID[clientIdx],strlen(sendstring)+length);  
    _parser->debug_on(false);          
    _parser->write(sendstring,strlen(sendstring));  
    HAL_Delay(200);                
    _parser->send("AT+CIPCLOSE=%d",clientID[clientIdx]);
    return 0;
}


void ESP8266Webserver::debugOn(bool pD)
{
    dbg=pD;
    _parser->debug_on(pD);  
}

const char* ESP8266Webserver::gibWert(string suchstring)
{
    return ESP8266Webserver::gibWert(suchstring.c_str());
}

const char* ESP8266Webserver::gibWert(const char* suchstring)
{
    static char hilf[40];
    
    char *fundort;
    char *error;
    char* referer;
    char* favicon;
    char* post;
    
    post=strstr(recbuf,"POST");
    favicon=strstr(recbuf,"favicon");
    //if (favicon!=NULL) return NULL;
    error=strstr(recbuf,"ERROR");
    //if (error==NULL) return NULL;
    
    referer=strstr(recbuf,"Referer");

    int i=0;
    fundort=strstr(recbuf,suchstring);
    if (post==NULL)
    {
        if (fundort!=NULL&&(fundort<referer||referer==NULL))
        {
            fundort=fundort+strlen(suchstring)+1;
            while(i<20 && fundort[i]!=38 && fundort[i]>32 ) //space, &
            {
                hilf[i]=fundort[i];
                i++;
            }
            hilf[i]=0;
            
            if (dbg) printf("\r\nsuchergebnis=%s\r\n",hilf);
        
            return hilf; 
        }
        else return NULL;
    }
    else
    {
       if (fundort!=NULL)
       {
            fundort=fundort+strlen(suchstring)+1;
            
            while(i<40 && fundort[i]!='&' && fundort[i]!=0)//i<sizeof(fundort) ) 
            {
                hilf[i]=fundort[i];
                i++;
            }
            hilf[i]=0;
            
            if (dbg) printf("\r\nsuchergebnis=%s\r\n",hilf);
           
            for (int i=0;i<1000;i++) recbuf[i]=0;
            return hilf;           
       }
       else return NULL;
    }
}

void ESP8266Webserver::listAPs()
{
    int ips[4];
    //_parser->debug_on(true);
    _parser->send("AT+CWMODE=1"); 
    HAL_Delay(300);
    while (_parser->recv("OK")==false);
    HAL_Delay(1000);
    if (scanAPs==true)
    {
        _parser->send("AT+CWLAP");
        while (!_serial->readable());
        HAL_Delay(10000);
        printf("\r\nBuf=");
        while (_serial->readable())
                {
                    _parser->read(recbuf, 1);
                    printf("%s",recbuf); 
                }   
        printf("\r\n"); 
    }
    for (int i=0;i<5;i++)
    {
        _parser->send("AT+CWJAP=\"%s\",\"%s\"",ssid,passwort);  
        HAL_Delay(1000);
        if (_parser->recv("WIFI GOT IP")) i=6;
    } 
    _parser->send("AT+CIFSR");
    while (_parser->recv("+CIFSR:STAIP,")==false) 
    {
        _parser->send("AT+CIFSR");
        HAL_Delay(100);
    }
    
//    _parser->read(ipadr,15);
    _parser->scanf("\"%d.%d.%d.%d\"",&ips[0],&ips[1],&ips[2],&ips[3]);
    sprintf(ipadr,"%d.%d.%d.%d",ips[0],ips[1],ips[2],ips[3]);
    printf("%s",ipadr);
        
    _parser->send("AT+CIPMUX=1");
    while (_parser->recv("OK")==false);
    
    //_parser->debug_on(false);
}

char* ESP8266Webserver::gibIP()
{
    static char ipa[16];
    int j=0;
    for (int i=0;i<strlen(ipadr);i++)
    {
        if (i==0 && ipadr[0]=='"'){}
        else
        {        
        switch (ipadr[i])
        {
            case '0':
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9':
            case '.': ipa[j]=ipadr[i];
                        j++;
                        break;
            default: i=10000; break;
        }
        if (i==10000) break;
        }
    }
    ipa[j+1]='\0';

    return ipa;
}

