/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"
#include "LCD.h"

lcd mylcd;

int Zustand=0;
int x=0;

InterruptIn A(PB_1); //DT
InterruptIn B(PB_0); //CLJ
PortIn drehgeber(PortB,0b11);

void Arise()
{
    switch(Zustand)
    {
        case 0: Zustand=1;
            x++;
            break;
        case 3: Zustand=2;
            x--;
            break;
    }
}

void Afall()
{
    switch(Zustand)
    {
        case 1: Zustand=0;
            x--;
            break;
        case 2: Zustand=3;
            x++;
            break;
    }
}

void Brise()
{
    switch(Zustand)
    {
        case 1: Zustand=2;
            x++;
            break;
        case 0: Zustand=3;
            x--;
            break;
    }
}

void Bfall()
{    
    switch(Zustand)
    {
        case 2: Zustand=1;
            x--;
            break;
        case 3: Zustand=0;
            x++;
            break;
    }
}



int main()
{
    A.rise(&Arise);
    A.fall(&Afall);
    A.enable_irq();
    B.rise(&Brise);
    B.fall(&Bfall);
    B.enable_irq();
    Zustand=drehgeber;

    
    mylcd.clear();
    
    while (true) {
        
            
            mylcd.cursorpos(0);
            mylcd.printf("Position %d   ",x);
    
        
     }
}
