/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "LCD.h"


// Blinking rate in milliseconds
#define BLINKING_RATE     20ms
BufferedSerial hc05(PB_10,PB_11,9600);
DigitalOut a(PC_0);
DigitalOut b(PC_1);
DigitalOut c(PC_2);
DigitalOut d(PC_3);

DigitalIn l(PB_0);
DigitalIn m(PB_3);
DigitalIn n(PB_4);

lcd mylcd;

int main()
{
    char daten[15];
    l.mode(PullDown);
    m.mode(PullDown);
    n.mode(PullDown);
    int altL=0,altM=0,altN=0;
    int anz;

    // Initialise the digital pin LED1 as an output
    DigitalOut led(LED1);
    mylcd.clear();
    mylcd.cursorpos(0);
    while (true) {
        led = !led;
        if (l==1&&altL==0)hc05.write("*LR255G0B0*",11);
        if (m==1&&altM==0)hc05.write("*MR0G255B0*",11);
        if (n==1&&altN==0)hc05.write("*NRG0B255*",11);
        if (l==0&&altL==1)hc05.write("*LR0G0B0*",9);
        if (m==0&&altM==1)hc05.write("*MR0G0B0*",9);
        if (n==0&&altN==1)hc05.write("*NR0G0B0*",9);
        altL=l;
        altM=m;
        altN=n;
        if (hc05.readable())
        {
            ThisThread::sleep_for(BLINKING_RATE);
            anz=hc05.read(daten,15);
            for (int i=0;i<anz;i++)
            {
                if (daten[i]=='A') a=1;
                if (daten[i]=='B') b=1;
                if (daten[i]=='C') c=1;
                if (daten[i]=='D') d=1;
                if (daten[i]=='a') a=0;
                if (daten[i]=='b') b=0;
                if (daten[i]=='c') c=0;
                if (daten[i]=='d') d=0;
                
                
            }
            
        }
        ThisThread::sleep_for(BLINKING_RATE);
    }
}
