//basiert auf dem DS1820-Example von Paul Staron

#include "mbed.h"
#include "DS1820.h"
#include "LCD.h"
#include "ESP8266Webserver.h"


DigitalOut led(LED1);
lcd myLCD;

#define DATA_PIN        PB_0
#define MAX_PROBES      16
DS1820* probe[MAX_PROBES];

ESP8266Webserver myWebserver;

Timer t;

int     DS;
float   Temp[16]; 

string getRootPage()
{
      string webpage;
      webpage="<!DOCTYPE html>";
      //HTML
      webpage+="<html>";
      webpage+="<head>";
      webpage+="<title>STM32 HTTP</title>";
      webpage+="</head>";
      webpage+="<body>";
      webpage+="<h1>WIFI mit STM32 ESP01</h1>\n";
      webpage+="<p>Temperatur= "+to_string(Temp[0])+"C</p>\n"; 
      webpage+="</body>";
      webpage+="</html>";
      return webpage;
}
    
void testfunc()
{
    myWebserver.send(200,"text/html",getRootPage());
}

int main(){
    myWebserver.on("/",&testfunc);
    myWebserver.begin();    
    myLCD.clear();
    myLCD.cursorpos(0);
    myLCD.printf("%s",myWebserver.gibIP());
    
    printf("\033[0m\033[2J\033[HInitialise...!\n\n");

    while (DS1820::unassignedProbe(DATA_PIN)) {
        probe[DS] = new DS1820(DATA_PIN);
        DS++;
        if (DS == MAX_PROBES) {
            break;
        }
    }
    
    if (!DS) {        
        printf("No Sensors found!\n\n");
        ThisThread::sleep_for(chrono::milliseconds(1000));
        NVIC_SystemReset();
    }

    // set each probe resolution, default is 12bit (750ms)
    probe[0]->setResolution(9);
//    probe[0]->setResolution(10);
//    probe[0]->setResolution(11);
//    probe[0]->setResolution(12);
//    probe[1]->setResolution(9);
//    probe[2]->setResolution(10);

    t.start();

    while(1) {
        myWebserver.handleClient();
        printf("\033[0m\033[2J\033[HDS Sensor data..\n\n");

        int DS_error = 0;
        for (int i = 0; i < DS; i++) {
            Temp[i] = probe[i]->temperature();
            if(Temp[i]==-1000) {
                Temp[i] = probe[i]->temperature();  // get read temp again if error
                DS_error++;
            }
            printf("Probe %d:  %3.2f %cc\r\n",i,Temp[i],0xb0);
            
            myLCD.cursorpos(0x40);
            myLCD.printf("%3.1f    ",Temp[0]);
        }
        printf("\nDS errors:  %d\n\n", DS_error);

        printf("Start conversion\n");
        t.reset();
        // don't wait for conversion, but do something that takes at least 750ms before reading the sensors
        //if(DS>0){probe[0]->convertTemperature(0, DS1820::all_devices);}
        
        // wait for conversion, can take up to 750ms(12 bit mode)
        if(DS>0){probe[0]->convertTemperature(1, DS1820::all_devices);}        
        
        printf("\nConvert process time: %0.6f Seconds\n", chrono::duration<float>(t.elapsed_time()).count());

        ThisThread::sleep_for(chrono::milliseconds(1000));
    }
}
