#include "mbed.h"


DigitalOut alarm(PC_0);
DigitalOut anzeige(PC_1);
InterruptIn flamme(PA_8);
AnalogIn batterie(PA_0);
DigitalIn test(PA_1);

bool alarmAktiv=false;

void isrFlamme(void)
{
   alarmAktiv=true;
   alarm=1;
   anzeige=1;
}

void warte(unsigned int ms)
{
    RCC->APB1ENR |= 0b100000; //TIM6
    TIM7->PSC=31999; //Prescaler für 1 ms
    TIM7->CNT=0;
    TIM7->ARR=ms;
    TIM7->SR=0;     //UIF=0
    TIM7->CR1=1; 
    while (TIM7->SR==0);
    TIM7->CR1=0;   
}

void TIM6_IRQHandler(void)
{
    if (anzeige==0) 
    {
        anzeige=1;
        TIM6->ARR=1000; //1Sekunde
        if (batterie<0.7) alarm=1;
    }
    else
    {
        anzeige=0;
        TIM6->ARR=10000; //10Sekunde
        if (!alarmAktiv) alarm=0;
    }
    
    TIM6->SR=0;
    HAL_NVIC_ClearPendingIRQ(TIM6_IRQn);
}

void flammeinit(void)
{
flamme.rise(&isrFlamme);
}

void NVIC_Init(void)
{
    /* TIM6_IRQn interrupt configuration */
    NVIC_SetVector(TIM6_IRQn, (uint32_t)&TIM6_IRQHandler);
    HAL_NVIC_EnableIRQ(TIM6_IRQn);
}

/* TIM6 init function */
void TIM6_Init(void)
{
    RCC->APB1ENR|=0b10000;  //Clock Enable
    TIM6->PSC=31999;         //Prescaler 100µs
    TIM6->ARR=1000;         //Autoreload 1000*1ms = 1s
    TIM6->DIER=1;           //UIE = 1 (Update Interrupt Enable)
    TIM6->SR=0;             //UIF =0 (Update Interrupt Flag)
    TIM6->CR1=1;            //CEN=1 (Counter Enable)
}


int main()
{
    TIM6_Init();

    flammeinit();
    NVIC_Init();
    test.mode(PullDown);
    while(1) {
        if (test==1)
        {            
            warte(3000);
            if (test==1)
            {
                TIM6->CR1=0;
                alarm=1;
                anzeige=1;
                warte(1000);
                alarm=0;
                anzeige=0;
                TIM6->CR1=1;
            }
        }
    }

}