/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"

Serial pc(USBTX, USBRX);
PortOut sekmin(PortC,0xFFFF);
PortOut st(PortB,0xFF);
DigitalOut blink(PA_5);


int sek=0, mins=59, stde=23;
unsigned int t1,t2;

void TIM6isr()
{
    blink=!blink;
    sek++;
    if (sek==60)
    {
        sek=0;
        mins++;
        if (mins==60)
        {
            mins=0;
            stde++;
            if (stde==24)
            {
                stde=0;   
            }
        }   
    }
    TIM6->SR=0;
    HAL_NVIC_ClearPendingIRQ(TIM6_IRQn);
}

/* TIM6 init function */
static void tim6_Init(void)
{
    RCC->APB1ENR|=0b10000;  //Clock Enable
    TIM6->PSC=31999;         //Prescaler 1ms
    TIM6->ARR=1000;         //Autoreload 1s
    TIM6->DIER=1;           //UIE = 1 (Update Interrupt Enable)
    TIM6->SR=0;             //UIF =0 (Update Interrupt Flag)
    TIM6->CR1=1;            //CEN=1 (Counter Enable)
    
    NVIC_SetVector(TIM6_IRQn, (uint32_t)&TIM6isr);
    HAL_NVIC_EnableIRQ(TIM6_IRQn);
}

void sendeZeit()
{
    pc.printf("%d,%d,%d,%d,%d,%d",
    (unsigned int)sekmin%16,
    (unsigned int)(sekmin/16)%16,
    (unsigned int)(sekmin/256)%16,
    (unsigned int)(sekmin/4096)%16,
    (unsigned int) st%16,
    (unsigned int) st/16);   
}

int main()
{
    volatile int sekalt=0;

    tim6_Init();
    
    while (true) {
        //sekmin=sek;
        if (sekalt!=sek)
        {
         //   sekmin=sek;
            sekalt=sek;
            t1=sek%10;
            t1=t1+((sek/10)<<4);
            t1=t1+((mins%10)<<8);
            t1=t1+((mins/10)<<12);
            t2=stde%10;
            t2=t2+((stde/10)<<4); 
            sekmin=t1;
            st=t2; 
            sendeZeit();
        }
    }
}
