/*
 * Simple example program
 *
 * Note: Don't forget to connect a 4.7k Ohm resistor 
 *       between the DS1820's data pin and the +3.3V pin
 *
 */
 
/* Single DS1820 sensor: */
/*
#include "mbed.h"
#include "DS1820.h"

Serial      pc(USBTX, USBRX);
DigitalOut  led(LED1);
DS1820      ds1820(D8);  // substitute D8 with the actual pin name connected to the DS1820 sensor
float       temp = 0;
int         result = 0;

int main()
{
    if (ds1820.begin()) {
        while (1) {
            ds1820.startConversion();   // start temperature conversion from analog to digital
            ThisThread::sleep_for(1000);// let DS1820 complete the temperature conversion
            result = ds1820.read(temp); // read temperature from DS1820 and perform cyclic redundancy check (CRC)
            switch (result) {
                case 0:                 // no errors -> 'temp' contains the value of measured temperature
                    pc.printf("temp = %3.1f%cC\r\n", temp, 176);
                    break;

                case 1:                 // no sensor present -> 'temp' was not updated
                    pc.printf("no sensor present\n\r");
                    break;

                case 2:                 // CRC error -> 'temp' was not updated
                    pc.printf("CRC error\r\n");
            }

            led = !led;
        }
    }
    else
        pc.printf("No DS1820 sensor found!\r\n");
}
*/


/*Several DS1820 sensors connected to the 1-wire bus:*/
#include "mbed.h"
#include "DS1820.h"
#include "LCD.h"

#define     MAX_SENSOSRS   32   // max number of DS1820 sensors to be connected to the 1-wire bus (max 256)

DS1820*     ds1820[MAX_SENSOSRS];
Serial      pc(USBTX, USBRX);
DigitalOut  led(LED1);
OneWire     oneWire(PA_8);        // substitute D8 with the actual pin name connected to the 1-wire bus
int         sensorsFound = 0;   // counts the actually found DS1820 sensors


lcd mylcd;
DigitalIn k0(PB_0);
DigitalOut abluft(PC_0);

DigitalIn k1(PB_1);
DigitalOut rotinnen(PC_1);

DigitalIn k2(PB_2);

PwmOut zuluft(PC_6);
AnalogIn dreher(PA_0);

PwmOut umluft1(PC_7);
PwmOut umluft2(PC_8);
PwmOut umluft3(PC_9);


int main()
{
    k0.mode(PullDown);
    k1.mode(PullDown);
    k2.mode(PullDown);
    pc.printf("\r\n--Starting--\r\n");
    mylcd.clear();
    //Enumerate (i.e. detect) DS1820 sensors on the 1-wire bus
    for (sensorsFound = 0; sensorsFound < MAX_SENSOSRS; sensorsFound++) {
        ds1820[sensorsFound] = new DS1820(&oneWire);
        if (!ds1820[sensorsFound]->begin()) {
            delete ds1820[sensorsFound];
            break;
        }
    }

    switch (sensorsFound) {
        case 0:
            pc.printf("No DS1820 sensor found!\r\n");
            return -1;

        case 1:
            pc.printf("One DS1820 sensor found.\r\n");
            break;

        default:
            pc.printf("Found %d DS1820 sensors.\r\n", sensorsFound);
    }

    while (1) {
        mylcd.cursorpos(0);
        pc.printf("----------------\r\n");
        for (int i = 0; i < sensorsFound; i++)
            ds1820[i]->startConversion();       // start temperature conversion from analog to digital
        ThisThread::sleep_for(1000);            // let DS1820 sensors complete the temperature conversion
        for (int i = 0; i < sensorsFound; i++) {
            if (ds1820[i]->isPresent())
            {
                mylcd.printf("temp[%d] = %3.1f%cC\r\n", i, ds1820[i]->read(), 176); // read temperature
                pc.printf("temp[%d] = %3.1f%cC\r\n", i, ds1820[i]->read(), 176); // read temperature
            }
        }
        abluft=k0;
        
        if (k2==1) zuluft.write(0.7);
        else zuluft.write(0);
        
        rotinnen=k1;
        
        mylcd.cursorpos(0x40);
        mylcd.printf("%d",(int)(dreher*4095));   
        
        float d=dreher;
        umluft1=d;     
        umluft2=d;     
        umluft3=d;     
    }

}
