/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"


// Blinking rate in milliseconds
#define BLINKING_RATE_MS                                                    500

bool angefordert=false;

char phasen[10]= {
    0b01001001, //0 rot - rot - rot
    0b01001101, //1 rot - rot - rotgelb
    0b01001010, //2 rot - rot - grün
    0b01001100, //3 rot - rot - gelb
    0b01001001, //4 rot - rot - rot
    0b01101001, //5 rot - rotgelb - rot 
    0b01010001, //6 rot - grün - rot
    0b01100001, //7 rot - gleb - rot
    0b01001001, //8 rot - rot - rot
    0b10001001}; //9 grün - rot - rot

void anfordern(void)
{
   angefordert=true; 
}

int main()
{
    // Initialise the digital pin LED1 as an output
    int z=0;
    InterruptIn anforderung(PA_1);
    anforderung.mode(PullDown);
    PortOut ampel(PortC,0xFF);
    anforderung.rise(&anfordern);

    while (true) {
        ampel=phasen[z];
        thread_sleep_for(BLINKING_RATE_MS);
        if ((z==0||z==4||z==8)&&angefordert)
        {          
            ampel=phasen[9];
            thread_sleep_for(BLINKING_RATE_MS);
            angefordert=false;
        }
        z++;
        if (z>8) z=0;
        
    }
}
