/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"


int main()
{
    // Initialise the digital pin LED1 as an output
    DigitalOut Lampe(PC_7);
    DigitalOut Sirene(PC_0);
    PortOut RGB(PortC,0b1110);
    DigitalIn Taste(PB_0);
    DigitalIn Magnetkontakt(PB_1);
    DigitalIn Mikrofon(PB_2);
    DigitalIn Lichtschranke(PB_3);
    bool scharf=false;
    int z=0;
    RGB=0;
    while (true) {
        if (Taste==0) 
        {
            wait_ms(20);
            scharf = !scharf;
            while(Taste==0);
            wait_ms(20);            
        }
        if (scharf)
        {
            Lampe=1;
            if (Magnetkontakt==0) Sirene=1;
            if (Mikrofon==0) 
            {
                z++;
                wait(1);
                if (z==3) Sirene=1;
            }
            if (Lichtschranke==1) Sirene=1;
        }
        else
        {
           Sirene=0;
           Lampe=0; 
           z=0;
           RGB=0;
        }
        if (Sirene==1)
        {
            if (RGB==0) RGB=0b10;
            RGB=RGB<<1;           
            wait(1);
        }
    }
}
