/* ATCmdParser usage example
 * Copyright (c) 2016 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "ESP8266Webserver.h"
#include "LCD.h"
//#include "string"

#include <string>




PortOut diag(PortC,0xFF);
lcd myLCD;
ESP8266Webserver myWebserver;


string webpage;

string getRootPage2()
{

      webpage="<!DOCTYPE html>\n";
      //Javascript
      webpage+="<script type=\"text/javascript\">";
      webpage+="var x;";
      webpage+="function z(){location.assign(\"http://";
      webpage+=myWebserver.gibIP();//"192.168.1.117";
      webpage+="\");}";
      webpage+="function sT(){x=setInterval(z,5000);}";
      webpage+="function spT(){clearInterval(x);}";
      webpage+="onload=sT();";
      webpage+="</script>\n";
      //HTML
      webpage+="<html>\n";
      webpage+="<head>\n";
      webpage+="<title>STM32 HTTP</title>\n";
      webpage+="</head>\n";
      webpage+="<body>\n";
      webpage+="<h1>WIFI mit STM32 ESP01</h1>\n";
      webpage+="<p>Aufrufe:";
      webpage+=to_string(myWebserver.Aufrufe);
      
      webpage+="</p>\n"; 
      
      webpage+="<form>\n";
      webpage+="<label for=\"Suchbegriff\">Suchbegriff</label>\n";
      webpage+="<input id=\"Suchbegriff\" name=\"Suchbegriff\">\n";
      webpage+="<label for=\"alter\">ueber 18:</label>\n";
      webpage+="<input type=\"checkbox\" id=\"alter\" name=\"alter\">\n";
      webpage+="<button>finden</button>\n";
      webpage+="</form>\n";
      webpage+="<H2>LED On/Off </H2>\n";
      webpage+="<a href=\"ledAn\"><button>ON</button></a>\n";      
      webpage+="<a href=\"ledaus\"><button>OFF</button></a>\n";
      webpage+="</body>\n";
      webpage+="</html>\n";
  
      return webpage;

}

//Alternativ mit char* statt string

char* getRootPage()                                       
{

    static char webpage[1000];

      strcpy(webpage,"<!DOCTYPE html>\r\n");
      strcat(webpage,"<html>\r\n");
      strcat(webpage,"<head>\r\n");
      strcat(webpage,"<title>STM32 HTTP</title>\r\n");
      strcat(webpage,"</head>\r\n");
      strcat(webpage,"<body>\r\n");
      strcat(webpage,"<h1>WIFI mit STM32 ESP01</h1>\r\n");
      strcat(webpage,"<p>WebseiteZeiletest</p>\r\n"); 
      
      strcat(webpage,"<form>\r\n");
      strcat(webpage,"<label for=\"Suchbegriff\">Suchbegriff</label>\r\n");
      strcat(webpage,"<input id=\"Suchbegriff\" name=\"Suchbegriff\">\r\n");
      strcat(webpage,"<label for=\"alter\">ueber 18:</label>\r\n");
      strcat(webpage,"<input type=\"checkbox\" id=\"alter\" name=\"alter\">\r\n");
      strcat(webpage,"<button>finden</button>\r\n");
      strcat(webpage,"</form>\r\n");
      
      strcat(webpage,"<H2>LED On/Off </H2>\n");
      strcat(webpage,"<a href=\"ledAn\"><button>ON</button></a>\n");      
      strcat(webpage,"<a href=\"ledaus\"><button>OFF</button></a>\n");
      strcat(webpage,"</body>\r\n");
      strcat(webpage,"</html>\r\n");
      
      return webpage;

}

void testfunc()
{
    diag=diag|0x80;
    
    myWebserver.send(200,"text/html",getRootPage2());
}

void testfunc2()
{
    diag=0x40;
    myWebserver.send(200,"text/html",getRootPage2());
}
void testfunc3()
{
    diag=0x20;
    myWebserver.send(200,"text/html",getRootPage2());
}

void testfunc4()
{
    diag=diag|0x10;
    myLCD.clear();
    myLCD.cursorpos(0);
    myLCD.printf("%s",myWebserver.gibWert("Suchbegriff"));
    myLCD.cursorpos(0x40);
    myLCD.printf("%s",myWebserver.gibWert("alter"));
    myWebserver.send(200,"text/html",getRootPage2());
}

int main()
{

    myWebserver.on("Suchbegriff",&testfunc4);
    myWebserver.on("ledaus",&testfunc2);
    myWebserver.on("ledAn",&testfunc3);
    myWebserver.on("/",&testfunc);

    myWebserver.begin();
    
    myLCD.clear();
    myLCD.cursorpos(0);
    myLCD.printf("%s",myWebserver.gibIP());
    


    while(1)
    {
         myWebserver.handleClient();
    }
    
}
