/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"


// Blinking rate in milliseconds
#define BLINKING_RATE_MS                                                    500

void warte()
{   
    asm("push   {R0,R1}          \n"
        "ldr R0,=32000000/5*3   \n"
        "mov R1,#1              \n"
        "1:                     \n"  
        "subs  R0,R1            \n"
        "bne   1b               \n"
        "pop   {R0,R1}          \n"
        );    
}

int main()
{
    // Initialise the digital pin LED1 as an output
    DigitalOut led(PA_5);

    while (true) {
        led = !led;
        //thread_sleep_for(BLINKING_RATE_MS);
        //HAL_Delay(BLINKING_RATE_MS);
        warte();
    }
}
