#include "mbed.h"
#include "EC.h"
#include "number.h"

#define pi 3.1415926535
#define CALC_INTERVAL 0.01      //角速度の計算間隔
#define SOLUTION 500            //エンコーダの分解能

#define TRY_MODE '0'            //お試しモード
#define ROTATION_MODE '1'       //立ち上がりの記録モード
#define PID_MODE '2'            //角度制御モード
#define PID_VELOCITY_MODE '3'   //角速度制御モード

SpeedControl em(PA_6,PA_7,NC,SOLUTION,CALC_INTERVAL,PB_5,PB_4); //エンコーダとモータはclass SpeedControllerにより制御する
Serial pc(USBTX,USBRX); //teratermによる入出力
void setup();       //セットアップ
void print_scan();  //teratermによる入出力関数

int loop_kai=0;
char mode='0';
double duty=0;
float data[500][2];
int i=0;

bool print=false;

double target_rotation=0,now_rotation=0,old_rotation=0;
double diff=0,diff_old=0,integral=0;
double Kp=0,Kd=0,Ki=0;

double Kp_v=0,Kd_v=0;

Ticker omega_tick;
Timer timer;
Num num(USBTX,USBRX);

//角速度計算関数
//一定時間ごとに割り込む
void CalOmega()
{
    em.CalPreOmega();
    if(mode==ROTATION_MODE&&i<500){ //プログラムが走り出してから5秒間でログをとる
        data[i][0]=(float)timer.read();
        data[i][1]=(float)em.getOmega()*60/(2*pi);
        i++;
    } else if(mode==PID_MODE){      //回転数の計算
        now_rotation=em.getCount()/SOLUTION;
    }
}

int main(void){
    setup();
    
    while(1){
        if(mode==ROTATION_MODE){    //5秒後にteratermにログを吐き出す
            if(i==500){
                for(int j=0;j<500;j++){
                    pc.printf("%f,%f\r\n",data[j][0],data[j][1]);
                }
                i++;
            }
        } else if(mode==PID_MODE){  //角度制御のためのduty比のPID制御による算出
            diff=target_rotation-now_rotation;
            integral+=diff;
            duty=Kp*diff+Kd*(diff-diff_old)+Ki*integral;
            diff_old=diff;
        }
        //モータの駆動
        if(duty>0){
            em.turnF(duty);
        } else {
            em.turnB(-1*duty);
        }
        
        //ループ10000回ごとにprintおよびscanを行う
        if(loop_kai%=10000){
            if(mode!=ROTATION_MODE)print_scan();
            if(loop_kai==300000)loop_kai=0;
        }
        loop_kai++;
    }
}

void setup(){
    pc.printf("\r\nMode 0 : otameshi\r\n");
    pc.printf("Mode 1 : time-rpm jikkenn\r\n");
    pc.printf("Mode 2 : Angle PID jikkenn\r\n");
    pc.printf("Mode 3 : rad/s PID jikkenn\r\n");
    pc.printf("Input mode : ");
    while(1){
        if(pc.readable()) {
            mode=pc.getc();
            pc.printf("%c\r\n",mode);
            break;
        }
    }
    if(mode==ROTATION_MODE){
        pc.printf("duty= ");
        duty=num.get_number();
    } else if(mode==PID_MODE){
        pc.printf("target_rotation= ");
        target_rotation=num.get_number();
    } else if(mode==PID_VELOCITY_MODE){
        /*em.setFBcoefficients(195,-7.26,372,7.06);
        em.setPDparam(0,0);*/
    }
    pc.printf("\r\n start !\r\n");
    timer.start();
    omega_tick.attach(CalOmega,CALC_INTERVAL);  //角速度計算関数の繰り返しタイマー割り込みの宣言
}

void print_scan(){
    if(print)pc.printf("time=%f count=%f rotation=%f rpm=%f F=%f B=%f\r\n",timer.read(),em.getPreCount(),em.getPreCount()/SOLUTION,em.getOmega()*60/(2*pi),(double)em.pwm_F_,(double)em.pwm_B_);
    //pc.printf("F=%f B=%f\r\n",(double)em.pwm_F_,(double)em.pwm_B_);
    
    if(pc.readable()) {
        char sel=pc.getc();
        
        switch(sel) {
            case 'i':   //duty比を0.01増やす
                duty+=0.1;
                pc.printf("duty=%f \r\n",duty);
                break;
            case 'o':   //duty比を0.01減らす
                duty-=0.1;
                pc.printf("duty=%f \r\n",duty);
                break;
            case 'n':
                Kp+=0.01;
                pc.printf("Kp=%f \r\n",Kp);
                break;
            case 'k':
                Kp_v+=0.01;
                em.setPDparam(Kp_v,0);
                pc.printf("Kp_v=%f \r\n",Kp_v);
                break;
            case 's':   //モータの回転を止める
                pc.printf("stop motor\r\n");
                duty=0;
                break;
            case 'p':   //teraterm上にprintするかしないか
                pc.printf("change print state\r\n");
                print=!print;
                break;
        }
    }
}