#ifndef LIBRARY_NUMBER_H
#define LIBRARY_NUMBER_H

#include "mbed.h"

///キーボード入力された数字文字を数値化
 
//! ＜動作確認用プログラム＞
/// 上限9桁で入力した数字文字を数値化して表示する
/** ledの点消でのデバック,このlibraryと同時にSerial通信での表示ができることを確認
@code
#include "mbed.h"
#include "number.h"

DigitalOut myled(LED1);

Num n_1(USBTX,USBRX,9);
Serial pc(USBTX,USBRX);

int main() {
    printf("start\r\n");
    while(1) {
        pc.printf("\tdata:%f\r\n",n_1.get_number());
        myled = !myled;
        wait(0.1);
    }
}
@endcode
 */ 
class Num{
private:
    int pow_int(int a,int b);
    int size_int(char a[]);
    int datasize;
        
protected:
    Serial pc_;

public:
/**コンストラクタの定義
 * メンバ変数の初期化を行う
 */
/**通常のpin定義のように使用するpinをプログラム内で実装する前に定義する
 * @param tx USBTXを定義する
 * @param rx USBRXを定義する
 * @param limit 入力する数字の桁数の上限を定義する、
 * @remarks 数字の桁数は'-'(負記号)や'.'(小数点)を除いた数字のみの桁数、何も入力しなかった場合の上限は5
 * @remarks また11桁以上は精度が保証できず誤作動の原因になるため、11以上が入力された場合上限は10になる
 */
    Num(PinName tx,PinName rx,int limit = 5);

/**get_number関数の定義
 * キーボード入力された数字文字を数値に変換する関数
 */
/**@remarks 先頭以外の'-',２つ以上の'.',数字以外の文字が入力されたとき終了
 * @return 入力された値を返す
 * @remarks 返却する値はdouble型、何も入力しなかった場合は0が返却される
 */
    double get_number();

};

#endif