#include "number.h"
#include "mbed.h"

Num::Num(PinName tx,PinName rx,int limit) : pc_(tx,rx){
    if(limit>10){
        datasize=10;
    }else{
        datasize = limit;
    }
}

int Num::pow_int(int a,int b){   //累乗の計算
    int result = 1;
    while(b > 0){
        result *= a;
        b--;
        }
    
    return result;
}

int Num::size_int(char a[]){     //文字数を計算
    int n=0;
    while(a[n]){
        n++;
    }
    
    return n;
}

double Num::get_number(){
    double target = 0;
    char data[datasize+1];
    int data_int[datasize+1];
    int count = 0;
    int size = 0;
    bool sign = 0;
    int point = 0;
    bool dot = 0;
    bool deci = 0;
    
    while(1){
        if(pc_.readable()){
            data[count] = pc_.getc();
            data_int[count] = (int)data[count] - 0x30;      //数値化
            
            if(count == 0 && data[count] == '-'){                   //先頭で'-'を入力した場合
                pc_.printf("%c",data[count]);
                data_int[count] = 0;
                sign = 1;
            
            }else if(deci == 0 && data[count] == '.'){              //少数点を入力した場合
                pc_.printf("%c",data[count]);
                deci = 1;
                if(count == 0){ //小数点が先頭のとき
                    data[count] = 0;
                    dot = 1;
                }else{          //その他のとき
                    point = count;
                }
            
            }else if(data[count] >= '0' && data[count] <= '9'){     //数値を入力した場合
                pc_.printf("%c",data[count]);
                if(count < datasize - 1)count++;
                else{
                    count = 0;
                    data[datasize] = '\0';
                    break;
                }
            
            }else{                                                  //数値以外を入力した場合
                data[count] = '\0';
                count=0;
                break;
            }
        }
    }
    
    
    //文字数を計算
    size=size_int(data);
    
    //数値化処理
    for(int i = 0;i < size;i++){
            target += data_int[i] * pow_int(10,(size - i - 1));
        }
        
    //正負処理   
    if(sign)target = (-1) * target;
    
    //小数処理
    if(dot){
        target /= pow_int(10,size);
    }else if(point > 0){
        target /= pow_int(10,size - point);
        }
    
    return target;
}
