/*******************************************************************************
 * Copyright (c) 2014 IBM Corp.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v1.0 which accompany this distribution.
 *
 * The Eclipse Public License is available at
 *    http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 *   http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *    Ian Craggs - initial API and implementation and/or initial documentation
 *******************************************************************************/

/**
 This is a sample program to illustrate the use of the MQTT Client library
 on the mbed platform.  The Client class requires two classes which mediate
 access to system interfaces for networking and timing.  As long as these two
 classes provide the required public programming interfaces, it does not matter
 what facilities they use underneath. In this program, they use the mbed
 system libraries.

*/
#include "mbed.h"

#include "MQTTESP8266.h"
#include "MQTTClient.h"

#define u8  char
#define u16 int
#define USART_REC_LEN           200     //隅膽郔湮諉彶弇啋瞎 200
#define RED    1
#define YELLOW 2
#define GREEN  3
#define ON  0
#define OFF 1
// #define true  0
#define OFF 1

Serial pc(PA_0, PA_1);//RGB
Serial pc1(PC_6, PC_7);//徨?
Serial esp(D8,D2);
DigitalOut wifi_reset(D6); // WiFi Reset

char SN[16]="123456789abcdef";
char RGB =1;  
uint16_t number=0;
float PT;
DigitalOut led(LED1);
DigitalOut led1(D5);
extern DigitalOut led;

//InterruptIn  Begin(PC_0);
//InterruptIn  End(PC_1);
DigitalIn  Clear(PC_2);

InterruptIn Begin(A2);
InterruptIn End(A3);

Timer timer;

u8 LIGHT_ZERO[3]={0xA5,0x6A,0x0F};     
u8 USART_RX_BUF[USART_REC_LEN];     //諉彶?茇,郔湮USART_REC_LEN?弇啋瞎.
u16 USART_RX_STA=0;       //諉彶?   //RGB
u8 SERIAL_RX_BUF[USART_REC_LEN];     //諉彶?茇,郔湮USART_REC_LEN?弇啋瞎.
u16 SERIAL_RX_STA=0;       //諉彶?  //徨?
bool b,begin_b,end_b;

void fallfunc_begin();
void fallfunc_End();
void echouart(), echouart1();

void fallfunc_begin()
{
   if (begin_b == false)
   {begin_b=true; timer.start();
   //printf("enter 1 -->");
   number++;
    led1=1; 
    }
   // printf("enter 2 \n\r");
}

void fallfunc_end()
{   if(end_b==false)
    { end_b=true; led=1; 
//pc1.printf(" %f ",timer.read());
//   pc1.printf(" %d ",timer.read_us());
     //printf("exit 1 -->");
     PT=timer.read();
     timer.reset();//?笭离0
     timer.stop();
    }
    //printf("exit 2 \n\r");
}

void echouart()   //RGB
{   u8 Res;
    Res=pc.getc();
    USART_RX_BUF[USART_RX_STA]=Res ;
    USART_RX_STA++;
    if(USART_RX_STA>(USART_REC_LEN-1))USART_RX_STA=0;//諉彶揃蹋嶒悷,笭陔嶱宎諉彶      
    //pc.putc(pc.getc());
    
}

void echouart1()  //徨?
{   u8 Res;
    Res=pc1.getc();
    SERIAL_RX_BUF[SERIAL_RX_STA]=Res ;
    SERIAL_RX_STA++;
    SN[SERIAL_RX_STA]=SERIAL_RX_BUF[SERIAL_RX_STA];
    if(SERIAL_RX_STA>(USART_REC_LEN-1))SERIAL_RX_STA=0;//諉彶揃蹋嶒悷,笭陔嶱宎諉彶      
    //pc.putc(pc.getc());\

}
// ================================================================
/*
char ssid[32] = "MyAP"; // enter router ssid inside the quotes
char pwd [32] = "kuan12345";// enter router password inside the quotes
char* hostname = "192.168.43.146"; // broker IP address
*/

char ssid[32] = "MITAC_LMC"; // enter router ssid inside the quotes
char pwd [32] = "Aa000000";// enter router password inside the quotes
char* hostname = "10.87.12.133"; // broker IP address

//char* hostname = "85.119.83.194"; // test.mosquitto.org
//char* hostname = "52.29.27.181"; // broker IP HiVMQ



float received;
char received_buf[50];
char topic_sub[50];
char topic[50];
char buf[100];
char timebuf[32];

// publish S1/M01
char* topicA = "S1/M01/SN"; // Serial Number
char* topicB = "S1/M01/QN"; // Quantity Count
char* topicC = "S1/M01/PT"; // process time
char* topicD = "S1/M01/RGB";  // Lamp Color
/*
// subscribe S1/M02
char* topic0 = "S1/M02/SN"; 
char* topic1 = "S1/M02/QN";
char* topic2 = "S1/M02/PT";
char* topic4 = "S1/M02/RGB";
*/ 

void startconnect();
void setRTC();
// void alert();
//void SMM();
//void echouart(), echouart1();

int arrivedcount = 0;

//==============================================
int main()
{  int i = 1;
    u8 len,len1;
    u16 red,green,blue;
    int t;

// ========================MQTT場宎趙================
    pc1.baud(9600);
    pc.baud(9600);
//  pc.printf("Please input!");
//    pc1.printf("Please input!");
/*
    pc.attach(&echouart,SerialBase::RxIrq);
    pc1.attach(&echouart1,SerialBase::RxIrq);
    begin.fall(&fallfunc_begin);
    end.fall(&fallfunc_end);   
*/
    esp.baud(115200);   // ESP8266 baudrate. Maximum on KLxx' is 115200, 230400 works on K20 and K22F
    
      for(t=0;t<3;t++)
    {pc.putc(LIGHT_ZERO[t]);} //RGB  //參腕善腔揃蹋追堤,蚚黺捼?
        
    printf("\n\r----- Smart Machine Monitor  0A1-----\n\r");     
    led1=1;   // Start 
    wifi_reset=0; // wifi ESP8226 reset
    setRTC();
    wifi_reset=1; 
    wait(1);
    
    startconnect(); // WiFi connection
  
    MQTTESP8266 ipstack(D8, D2, D6, ssid, pwd); // tx D8, rx D2, reset D6

    MQTT::Client<MQTTESP8266, Countdown> client = MQTT::Client<MQTTESP8266, Countdown>(ipstack);
    int port = 1883;
    int rc = ipstack.connect(hostname, port);
    if (rc != 0)
    printf("rc from TCP connect is %d\n\r", rc);

    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
    data.MQTTVersion = 3;
    
    data.clientID.cstring = "mbed01";
    data.username.cstring = "user01";
    data.password.cstring = "pwd01";
    
    if ((rc = client.connect(data)) != 0)
       { printf("rc from MQTT connect is %d\n\r", rc);}

    MQTT::Message message;
    
 //   SMM();
// preset value
  //  char SN[16]="123456789abcdef";
    RGB=1;  
    number=0; // quantity
    PT=12; // Process Time
    
    pc.attach(&echouart,SerialBase::RxIrq);
    pc1.attach(&echouart1,SerialBase::RxIrq);
    Begin.fall(&fallfunc_begin);
    End.fall(&fallfunc_end);   
// ==================end======================
//while(1)
// {
    for(i=1;i<999;i++)
    {

   /////////////////////徨?//////////////////////////////////       
    if(SERIAL_RX_STA>9)
    {  len1=SERIAL_RX_STA;//腕善森棒諉彶善腔揃蹋墿僅
     for(t=0;t<len1;t++)
        {
         SN[t]=SERIAL_RX_BUF[t];
         pc1.putc(SERIAL_RX_BUF[t]);
         }//參腕善腔揃蹋追堤,蚚黺捼?
         pc1.printf(",%u ",RGB);//參?伎追堤蚚黺捼?
         SERIAL_RX_STA=0; 
         number++; //蚚黺??PCB啣?
         pc1.printf("Number=%d ",number);
         if(Clear==1)// PCB啣?錨
         {number=0;}
    }  //徨?
             
 /////////////////////RGB////////////////////////////////////            
    if(USART_RX_STA>7)
    {  len=USART_RX_STA;//腕善森棒諉彶善腔揃蹋墿僅
     for(t=0;t<len;t++)
        {pc.putc(USART_RX_BUF[t]);} //RGB  //參腕善腔揃蹋追堤,蚚黺捼?
              USART_RX_STA=0; 
     if(USART_RX_BUF[0] == 0x5A)
        { USART_RX_BUF[9]=(USART_RX_BUF[0]+USART_RX_BUF[1]+USART_RX_BUF[2]+
        USART_RX_BUF[3]+USART_RX_BUF[4]+USART_RX_BUF[5]+USART_RX_BUF[6])&0xff;
          if(USART_RX_BUF[9] == USART_RX_BUF[7])// RGB 苺?
          { red=USART_RX_BUF[4];    //pc.putc(red);  RED弇啋
            green=USART_RX_BUF[5];  //pc.putc(green);green弇啋
            blue=USART_RX_BUF[6];   //pc.putc(blue); blue弇啋
          }
        }
      
    }
     if(0x70<=red && red<=0x90 && 0x0C<=green && green<=0x4C && 0x0B<=blue && blue<=0x4B)       //RED瓚隅嶲,?虐噫奧隅,嘛?硉
        {RGB=RED;}
     else if(0x89<=red && red<=0xFF && 0x66<=green && green<=0xA6 && 0x37<=blue && blue<=0x77)  //YELLOW瓚隅嶲,?虐噫奧隅,嘛?硉
        {RGB=YELLOW;}
     else if(0x12<=red && red<=0x62 && 0x36<=green && green<=0x76 && 0x23<=blue && blue<=0x63)  
        {RGB=GREEN;}
     else      
        {RGB=0;}
 
 ////////////////////////////////////////////////////    
   begin_b=false;  end_b=false;
  // printf("--- Wait for Enter --\n\r");
    while (begin_b==false)
    { led=1; wait(0.5); led=0; wait(0.5); } 
     while (end_b==false) 
    {led1=1; wait(0.5); led1=0; wait(0.5);} 
    
 // for(int i1=1;i1<10;i1++) {
   //i++;
   // SMM();
    sprintf(buf,"%16s",SN);  // SN from bar Code reader
    printf("|%3d SN=%s ",i, buf);
    message.qos = MQTT::QOS1;
    message.retained = true;  // add
    message.dup = false; // add
    message.payload = (void*)buf;  // add
    message.payloadlen = strlen(buf)+1;
    rc = client.publish(topicA, message);
   // while (arrivedcount < 0)
   // client.yield(100);
    wait (0.05);  
//    sprintf(SN,"%16s",0);  // SN from bar Code reader
        
    sprintf(buf,"%5d",number);
    printf("|count=%s ", buf);
    message.qos = MQTT::QOS1;
    message.retained = true;  // add
    //message.dup = false; // add
    //message.payload = (void*)buf;  // add
    message.payloadlen = strlen(buf)+1;
    rc = client.publish(topicB, message);
   // while (arrivedcount < 0)
   //client.yield(100);
    wait (0.05);  
    
    sprintf(buf,"%5.2f",PT);
    printf("|PT=%s" ,buf);
    message.qos = MQTT::QOS1;
    message.retained = true;  // add
    // message.dup = false; // add
    // message.payload = (void*)buf;  // add
    message.payloadlen = strlen(buf)+1;
    rc = client.publish(topicC, message);
    //while (arrivedcount < 0)
    //client.yield(100);
    wait (0.5); 
     
    sprintf(buf,"%d",RGB);
    printf("| RGB=%s|\n\r", buf);
    message.qos = MQTT::QOS1;
    message.retained = true;  // add
    //message.dup = false; // add
    //message.payload = (void*)buf;  // add
    message.payloadlen = strlen(buf)+1;
    rc = client.publish(topicD, message);
    //while (arrivedcount < 0)
    //client.yield(100);
    wait (1);  
    begin_b=false;  end_b=false;
   // }
  }
    if ((rc = client.disconnect()) != 0)
        printf("rc from disconnect was %d\n\r", rc);
        
     ipstack.disconnect();
      printf("Finishing with %d messages received\n\r", arrivedcount);
// }

}
// ===============================================

