/*
 SD pins: DI = p5, DO = p6, SCK = p7, CS = p8
*/


#define MULTIPLE_PROBES
#define ARM1_DATA_PIN        p19
#define TAIL_DATA_PIN        p20
#define ARM2_DATA_PIN        p30

#include "mbed.h"
#include "DS1820.h"
#include "ExtendedTimer.h"
#include "SDFileSystem.h"

#define MAX_PROBES      45


DS1820* probe1[20];
DS1820* probe2[20];
DS1820* probeTail[20];
SDFileSystem fs(p5, p6, p7, p8, "fs");
Serial pc(USBTX,USBRX);


int main()
{
    float lastFlush = 0;
    float flushInterval = 5*60;
    float lastMeasurement = 0;
    float measurementInterval = 30;
    
    // Mount the filesystem
    bool mountFailure = fs.mount();
    if (mountFailure != 0) {
        pc.printf("Mount failure!\r\n");
        return -1; // ends program with error status
    }
    pc.printf("Mount success!\r\n");  

    //File for arm 1 data
    FILE * output1;
    //file for arm 2 data
    FILE* output2;
    //file  for tail data
    FILE* outputt;

    output1 = fopen("/fs/Arm1.txt", "a");
    output2 = fopen("/fs/Arm2.txt", "a");
    outputt = fopen("/fs/Tail.txt", "a");

    ExtendedTimer t;
    //start the timer
    t.start();

//Find Arm1 Probes
    // Initialize the probe array to DS1820 objects
    int num_devices1 = 0;
    //Iterator for stepping through name[]
    //int count = 0;
    pc.printf("Searching on arm 1...\r\n");
    while(DS1820::unassignedProbe(ARM1_DATA_PIN)) {
        probe1[num_devices1] = new DS1820(ARM1_DATA_PIN);
        num_devices1++;
        //count ++;
        if (num_devices1 == MAX_PROBES)
            break;
    }
    pc.printf("Found %d device(s)\r\n\n", num_devices1);
    
    pc.printf("Searching on arm 2...\r\n");
    //Find Arm2 Probes
    // Initialize the probe array to DS1820 objects
    int num_devices2 = 0;
    //Iterator for stepping through name[]
    //int count = 0;
    while(DS1820::unassignedProbe(ARM2_DATA_PIN)) {
        probe2[num_devices2] = new DS1820(ARM2_DATA_PIN);
        num_devices2++;
        //count ++;
        if (num_devices2 == MAX_PROBES)
            break;
    }
    pc.printf("Found %d device(s)\r\n\n", num_devices2);

    pc.printf("Searching on tail...\r\n");
    //Find Tail Probes
    // Initialize the probe array to DS1820 objects
    int num_devicest = 0;
    //Iterator for stepping through name[]
    //int count = 0;
    while(DS1820::unassignedProbe(TAIL_DATA_PIN)) {
        probeTail[num_devicest] = new DS1820(TAIL_DATA_PIN);
        num_devicest++;
        //count ++;
        if (num_devicest == MAX_PROBES)
            break;
    }
    pc.printf("Found %d device(s)\r\n\n", num_devicest);


    unsigned long long fullName;
    unsigned int firstName;
    unsigned int lastName;
    // Write header row to each file with device IDs
    //tail
    fprintf(outputt,"Time\t");
    for(int count = 0; count < num_devicest; count ++) {
        fullName = probeTail[count]->whoAmI();
        firstName = fullName >> 32;
        lastName = fullName;
        fprintf(outputt, "%x%x\t", firstName, lastName);
    }
    //Arm1
    fprintf(output1,"Time\t");
    for(int count = 0; count < num_devices1; count++) {
        fullName = probe1[count]->whoAmI();
        firstName = fullName >> 32;
        lastName = fullName;
        fprintf(output1, "%x%x\t", firstName, lastName);
    }
    fprintf(output2,"Time\t");
    //Arm2
    for(int count = 0; count < num_devices2; count++) {
        fullName = probe2[count]->whoAmI();
        firstName = fullName >> 32;
        lastName = fullName;
        fprintf(output2, "%x%x\t", firstName, lastName);
    }
    fprintf(outputt,"\r\n");
    fprintf(output1,"\r\n");
    fprintf(output2,"\r\n");
 
    //start collecting data

    while(t.read()<4*60*60) {
        //conditional statement to trigger sensor readings
        if ((t.read()-lastMeasurement)>measurementInterval) {
            lastMeasurement = t.read();
            //Tail sensors being read
            probeTail[0]->convertTemperature(true, DS1820::all_devices);         //Start temperature conversion, wait until ready
            fprintf(outputt,"%3.1f \t",t.read());
            for(int i = 0; i < num_devicest; i++) {
                fprintf(outputt,"%3.1f \t",probeTail[i]->temperature());
            }
            probe1[0]->convertTemperature(true, DS1820::all_devices);
            fprintf(output1,"%3.1f \t",t.read());
            for(int i = 0; i < num_devices1; i++) {
                fprintf(output1,"%3.1f \t",probe1[i]->temperature());
            }
            probe2[0]->convertTemperature(true, DS1820::all_devices);
            fprintf(output2,"%3.1f \t",t.read());
            for(int i = 0; i < num_devices2; i++) {
                fprintf(output2,"%3.1f \t",probe2[i]->temperature());
            }
            fprintf(outputt,"\r\n");
            fprintf(output1,"\r\n");
            fprintf(output2,"\r\n");
        }

        if((t.read()-lastFlush)>flushInterval) {
            lastFlush = t.read();
            pc.printf("Wrote block of data at %3.1f s after power-up\r\n",lastFlush);
            fclose(outputt);
            fclose(output1);
            fclose(output2);
            output1 = fopen("/fs/Arm1.txt", "a");
            output2 = fopen("/fs/Arm2.txt", "a");
            outputt = fopen("/fs/Tail.txt", "a");
        }
        //fprintf(output, "Device %d returns %3.1fo\r\n", i, probe[i]->temperature());
        //flushing io buffer

    }
    fclose(outputt);
    fclose(output1);
    fclose(output2);
    fs.unmount();
}
