/* Home Environemnt Monitoring and Logging with STM32 IOT DISCOVERY Board   */
/*                                                                          */
/* Jaafar Benabdallah - 2017 */


/* Libraries */
#include "mbed.h"
#include "HTS221Sensor.h"
#include "LPS22HBSensor.h"
#include "LSM6DSLSensor.h"
#include "lis3mdl_class.h"
#include "VL53L0X.h"
#include "wifi.h"
#include "picojson.h"

/* Syncing Params */
#define SENSE_PERIOD_S  5.0
#define UPLOAD_PERIOD_S 30.0
#define CHECK_PROXIMITY_PERIOD_S  1.0

// Influx TSDB http api
#define INFLUX_SERVER_URL   "rpi1.nrjy.com"
#define INFLUX_SERVER_PORT  8086
#define INFLUX_WRITE_EP     "/write?db=HENV2&precision=s&rp=HENV2_1y"

// time server http api to get current unix time
#define TIME_SERVER_URL     "www.convert-unix-time.com"
#define TIME_SERVER_PORT    80
#define TIME_SERVER_EP      "/api?timestamp=now&timezone=New_York"

#define WIFI_WRITE_TIMEOUT 3000
#define WIFI_READ_TIMEOUT  3000
#define CONNECTION_TRIAL_MAX    3

/* Nextion display macros */

#define RESET_NEXTION           nextion.printf("rest\xff\xff\xff")
#define WIFI_ICON_ON            nextion.printf("vis wifi,1\xff\xff\xff")
#define WIFI_ICON_OFF           nextion.printf("vis wifi,0\xff\xff\xff")
#define UPLOAD_ICON_ON          nextion.printf("vis upload,1\xff\xff\xff")
#define UPLOAD_ICON_OFF         nextion.printf("vis upload,0\xff\xff\xff")
#define NO_WAKEUP_ON_SERIALIN   nextion.printf("usup=0\xff\xff\xff")
#define WAKEUP_ON_TOUCH         nextion.printf("thup=1\xff\xff\xff")
#define SLEEP_ON_NOTOUCH_30S    nextion.printf("thsp=30\xff\xff\xff")
#define WAKE_UP_DISPLAY         nextion.printf("sleep=0\xff\xff\xff")


/* Interface definition */
static DevI2C devI2c(PB_11,PB_10);
Serial pc(USBTX, USBRX, 115200);
Serial nextion(PA_0, PA_1, 115200); //i.e. D1, D0 : Serial 4
DigitalOut led3(LED3);// WiFi module status
DigitalOut ledhttp(LED2);// Http activity


/* Operation flags */
volatile bool   sense_enabled = false;
volatile bool   take_measurements = false;
volatile bool   send_measurements = false;
volatile bool   check_proximity = false;
bool rtc_synced = false;
bool WiFi_on = false;


/* Timers   */
Ticker  getMeasurementsTicker;
Ticker  sendMeasurementsTicker;
Ticker  checkProximityTicker;
// Ticker  WiFi_led_ticker;


/* Environmental sensors */
static LPS22HBSensor press_temp(&devI2c);
static HTS221Sensor hum_temp(&devI2c);
/* Motion sensors */
static LSM6DSLSensor acc_gyro(&devI2c,LSM6DSL_ACC_GYRO_I2C_ADDRESS_LOW,PD_11); // low address
static LIS3MDL magnetometer(&devI2c);
/* Range sensor  */
static DigitalOut shutdown_pin(PC_6);
static VL53L0X range(&devI2c, &shutdown_pin, PC_7);


/* Environment variables */
uint32_t distance_val = 0;
float tempC_val = 0;
float tempF_val = 0;
float RH_val = 0;
float Patm_val = 0;
float tempC_val2 = 0;


/* Comm vars */
static   uint8_t http_request[1024];
static   uint8_t http_resp[512];
uint16_t reqLen;
uint16_t respLen;
uint32_t request_sent = 0;
uint32_t request_acked = 0;


/* Functions Prototypes */
bool connectToServer(char *serverUrl, uint16_t serverPort, uint8_t socket_id);
bool connectWiFi(void);
bool checkWiFi(void);
void time_to_sense_cb(void);
void time_to_send_cb(void);
void time_to_check_distance_cb(void);
bool sync_rtc(void);
bool getCurrentTime(uint8_t socket_id, uint32_t *timeStamp);
// void toggle_led3_cb();
